<?php 
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');

include_once "base_controller.php";

class CertGenerator extends BaseController {
  protected function signinRequired() {
    return true;
  }

  private function certDir() {
    $curPath = dirname(__FILE__);
    $uploadDir = $curPath . DIRECTORY_SEPARATOR . "uploads";
    if (!is_dir($uploadDir))
      mkdir($uploadDir, 0777, true);

    $certDir = $uploadDir . DIRECTORY_SEPARATOR . "certs";
    if (!is_dir($certDir))
      mkdir($certDir, 0700, true);

    return $certDir;
  }

  public function doAjaxPost() {
    $response = array();
    $brokerType = "GoogleIoTCore";
    if (isset($_POST['brokerType']))
      $brokerType = $_POST['brokerType'];

    $name = "";
    if (isset($_POST['name']))
      $name = $_POST['name'];

    if (preg_match('/^[-_a-zA-z0-9]{1,32}$/', $name) == 0) {
      $this->renderAjaxError($response, "invalid cert name");
      return;
    }

    $cert_pat = build_file_path($this->certDir(), $name . "_cert-*.pem");
    $matches = glob($cert_pat);   
    if ($matches === false) {
      $this->renderAjaxError($response, "invalid cert name");
      return;
    }
    if (count($matches) > 0) {
      $this->renderAjaxError($response, sprintf("cert with name '%s' already exist.", $name));
      return;
    }

    $suffix = randStr(6);
    if ($brokerType == "GoogleIoTCore") {
      $cert_path = build_file_path($this->certDir(), $name . "_cert-$suffix.pem");
      $key_path = build_file_path($this->certDir(), $name . "_key-$suffix.pem");
      $cmd = "openssl req -x509 -newkey rsa:2048 -keyout $key_path -nodes -out $cert_path -days 3650 -subj '/CN=unused'";
      if (execShellCmd($cmd)) {
        $response['cert'] = file_get_contents($cert_path);
      } else
        $this->renderAjaxError($response, "failed to generate SSL cert for broker $brokerType");
    } else {
      $this->renderAjaxError($response, "broker type $brokerType is not supported yet");
    }

    $this->renderAjaxSuccess($response);
  }
}

$controller = new CertGenerator();
$controller->run();

?>
