"use strict";
$(function() {

  //define components 
  var bacnetPanelComp = { //{{{1
    template: '#bacnet-panel-template',
    data: function() {
      return {
        subscriptions: [],
        autoRefresh: true,

        query: "",

        state: "",

        delayedUpdateData: null,

        sortCol: null,
        ascSort: true,

        spinner: null,
      };
    },
    mounted: function() {
      this.updateData();
    },
    watch: {
      autoRefresh: function(val) {
        if (val)
          this.updateData();
      },
      query: function(val) {
        this.applyFilter()
      },
    },
    methods: {
      getSpinner: function() {
        if (!this.spinner)
          this.spinner = new Spinner();
        return this.spinner;
      },
      headers: function(sub) {
        return Object.keys(sub).filter(val => !val.startsWith("_"))
      },

      updateData: function() {
        var self = this;
        $.ajax({
          url: 'bacnet_panel.php',
          type: 'GET', 
          dataType: 'json',
          beforeSend: function() {
            self.getSpinner().spin(document.getElementById("controls"));
            self.state = "Loading ..."
          },
          success: function(resp) {
            if (resp.redirect)
              redirect(resp.redirect);

            self.subscriptions.splice(0)
            if (_.isArray(resp.subscriptions)) {
              for(let i=0; i<resp.subscriptions.length; ++i) {
                let sub = resp.subscriptions[i]
                sub['_show'] = true
                self.subscriptions.push(sub)
              }

              if (resp.subscriptions.length > 0) {
                let headers = Object.keys(self.subscriptions[0])
                if (headers.indexOf(self.sortCol) == -1)
                  self.sortCol = headers[0]

                self.sort()
                self.applyFilter()
              } else {
                self.updateStateMsg()
              }
            } else {
              //TODO: display error message 
              console.warn("error response:");
              console.warn(resp);
            }
          },
          error: function(data, status) {
            console.warn("get error");
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();

            // delayedUpdateData function will prevent updateData is called too often
            if (!self.delayedUpdateData) {
              self.delayedUpdateData = _.debounce(function() {
                if (!self.autoRefresh)
                  return

                self.updateData()
              }, 5000)
            }
            self.delayedUpdateData()
          }
        });
      },

      applyFilter: function() {
        if (this.subscriptions.length == 0) 
          return 

        let self = this
        let headers = self.headers(this.subscriptions[0])
        this.subscriptions.forEach(function(sub, index) {
          let found = headers.find(function(h) {
            let val = sub[h]
            return val.toLowerCase().includes(self.query.toLowerCase())
          })
          self.subscriptions[index]['_show'] = found !== undefined
        });

        this.updateStateMsg()
      },

      updateStateMsg: function() {
        let hideCount = this.subscriptions.reduce(function(init, sub) {
          init += sub['_show'] ? 0 : 1
          return init
        }, 0)

        if (hideCount > 0 || this.query != "")
          this.state = "" + (this.subscriptions.length-hideCount) + " matched / " + this.subscriptions.length + " in total"
        else
          this.state = "" + this.subscriptions.length + " in total"
      },

      sort: function() {
        let self = this
        self.subscriptions.sort(function(a, b) {
          let av = a[self.sortCol]
          let bv = b[self.sortCol]
          if (av == bv)
            return 0

          //TODO: handle more number type columns
          if (self.sortCol == "Process ID" || self.sortCol == "Time Remaining") {
            //compare as number type
            let iav = Number.parseFloat(av)
            let ibv = Number.parseFloat(bv)
            if (Number.isNaN(iav) || Number.isNaN(ibv)) {
              if (self.ascSort) 
                return av < bv ? -1 : 1
              else
                return av < bv ? 1 : -1
            } else {
              if (self.ascSort) 
                return iav < ibv ? -1 : 1
              else
                return iav < ibv ? 1 : -1
            }
          } else {
            //compare as string type by default
            if (self.ascSort)
              return av < bv ? -1 : 1
            else
              return av < bv ? 1 : -1
          }
        })
      },

      onColClicked: function(header) {
        if (header == this.sortCol)
          this.ascSort = !this.ascSort
        else
          this.sortCol = header

        this.sort()
      },

    },
  }; //}}}1

  //create&init root object
  var app = new Vue({ //{{{1
    el: '#bacnet_panel_content',
    data: {
    },
    methods: {
    },
    components: {
      // 'alert': alertComp,
      'bacnet-panel': bacnetPanelComp
    }
  }); //}}}1

});

// vim: foldmethod=marker
