<?php 
//vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class BACnetPanelController extends BaseController {

  protected function signinRequired() {
    return true;
  }
  protected function adminRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $response = array();

    $cmd = "bacnet cov"; 
    // $cmd = "bacnet cov -d all";
    $return_var = 0;
    $lines  = array();
    exec($cmd, $lines, $return_var);
    if ($return_var != 0 || count($lines) == 0) { //error
      $this->renderAjaxError($response, "failed to fetch BACnet CoV subscriptions");
    }

    $headers = explode("\t", rtrim($lines[0]));
    $response["subscriptions"] = array();
    if (count($lines) == 1) {
      $this->renderAjaxSuccess2($response);
    }
    for($i=1; $i < count($lines); $i++) {
      $cols = explode("\t", rtrim($lines[$i]));
      if (count($cols) != count($headers))
        continue;

      $row = array_combine($headers, $cols);
      $response["subscriptions"][] = $row;
    }

    $this->renderAjaxSuccess2($response);
  }
}

$controller = new BACnetPanelController();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("BACnet Panel") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="bacnet_panel_content">
      <div class="navbar">
        <div class="navbar-inner">
          <a id="home_nav_btn" class="brand" href="<?php echo $controller->utilityUrl() ?>"><?php echo $controller->utilityLabel() ?></a>
          <!-- <ul class="nav"> -->
          <!--   <li class="divider&#45;vertical"></li> -->
          <!--   <li v&#45;for="sec in sections" :class="{active:isSectionActive(sec)}"><a href="#" @click="active_sec_id=sec.sec_id">{{ sec.name }}</a></li> -->
          <!-- </ul> -->
        </div>
      </div>

      <div class="row">
        <div><h2 style="text-align:center">BACnet CoV Subscriptions</h2></div>
        <bacnet-panel></bacnet-panel>
      </div>
    </div>

    <!-- component templates -->
    <script type="text/x-template" id="bacnet-panel-template">
      <div class="span12">

        <div id="controls" style="margin-bottom: 10px;">
          <label style="display: inline;">
            <strong>Search:</strong>
            <input type="text" class="input-medium" style="margin-bottom: 0;" v-model.trim="query">
          </label>

          <span style="margin-left: 10px;"><i>{{ state }}</i></span>

          <button class="btn pull-right" type="button" style="margin-left: 10px;" @click="updateData">Refresh</button>
          <label class="checkbox inline pull-right">
            <input type="checkbox" v-model="autoRefresh"> Auto Refresh
          </label>
        </div>

        <div class="alert alert-block" v-if="!subscriptions || subscriptions.length == 0">
          <h5>No subscription data available yet</h5>
        </div>
        <table class="table table-striped table-hover" v-else>
          <thead>
            <tr>
            <th v-for="h in headers(subscriptions[0])" @click="onColClicked(h)" >
              {{ h }} <i v-if="h == sortCol" :class="[ascSort ? 'icon-arrow-up' : 'icon-arrow-down',]"></i>
            </th>
            </tr>
          </thead>
          <tbody>
            <tr v-for="sub in subscriptions" v-show="sub._show">
              <td v-for="h in headers(sub)">{{ sub[h] }}</td>
            </tr>
          </tbody>
        </table>
      </div>
    </script>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/bootstrap.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/underscore-min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>
    <script type="text/javascript" src="<?php A('../../js/plugin-utils.js') ?>"></script>
    <script type="text/javascript" src="<?php A('js/bacnet_panel.js') ?>"></script>

    <script language="javascript" type="text/javascript">
      "use strict";
      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>
  </body>
</html>
