(function()
{
  var L=function(str) { return l18n(str, 'dashboard/plugins/mqtt/paho.mqtt.plugin.js'); };
  // ### Datasource Definition
  //
  // -------------------
  freeboard.loadDatasourcePlugin({
    "type_name"   : "paho_mqtt",
    "display_name": "MQTT",
    "description" : L("Receive data from an MQTT server."),
    "external_scripts" : ["plugins/thirdparty/mqttws31-min.js"],
    "settings"    : [
      {
        "name"         : "server",
        "display_name" : L("MQTT Server"),
        "type"         : "text",
        "description"  : L("Hostname for your MQTT Server"),
        "required" : true
      },
      {
        "name"        : "port",
        "display_name": L("Port"),
        "type"        : "number", 
        "description" : L("The websocket port to connect to the MQTT Server on"),
        "default_value": 1883,
        "required"    : true
      },
      {
        "name"        : "use_ssl",
        "display_name": L("Use SSL"),
        "type"        : "boolean",
        "description" : L("Use SSL/TLS to connect to the MQTT Server"),
        "default_value": false
      },
      {
        "name"        : "client_id",
        "display_name": L("Client Id"),
        "type"        : "text",
        "default_value": "",
        "required"    : false
      },
      {
        "name"        : "username",
        "display_name": L("Username"),
        "type"        : "text",
        "default_value": "",
        "required"    : false
      },
      {
        "name"        : "password",
        "display_name": L("Password"),
        "type"        : "text",
        "default_value": "",
        "required"    : false
      },
      {
        "name"        : "topic",
        "display_name": L("Topic"),
        "type"        : "text",
        "description" : L("The topic to subscribe to"),
        "required"    : true
      },
      {
        "name"        : "json_data",
        "display_name": L("JSON messages?"),
        "type"        : "boolean",
        "description" : L("If the messages on your topic are in JSON format they will be parsed so the individual fields can be used in freeboard widgets"),
        "default_value": false
      }
    ],
    // **newInstance(settings, newInstanceCallback, updateCallback)** (required) : A function that will be called when a new instance of this plugin is requested.
    // * **settings** : A javascript object with the initial settings set by the user. The names of the properties in the object will correspond to the setting names defined above.
    // * **newInstanceCallback** : A callback function that you'll call when the new instance of the plugin is ready. This function expects a single argument, which is the new instance of your plugin object.
    // * **updateCallback** : A callback function that you'll call if and when your datasource has an update for freeboard to recalculate. This function expects a single parameter which is a javascript object with the new, updated data. You should hold on to this reference and call it when needed.
    newInstance   : function(settings, newInstanceCallback, updateCallback)
    {
      newInstanceCallback(new mqttDatasourcePlugin(settings, updateCallback));
    }
  });

  var mqttDatasourcePlugin = function(settings, updateCallback)
  {
    var self = this;
    var currentSettings = settings;
    var data = {};

    function onConnect() {
      console.log("Connected");

      // make the default data, otherwise the datasource's connection status
      // will be 'never' all the time
      data = {topic: currentSettings.topic, msg: ''};
      updateCallback(data);

      client.subscribe(currentSettings.topic);
    };
    
    function onConnectionLost(responseObject) {
      if (responseObject.errorCode !== 0)
        console.log("onConnectionLost:"+responseObject.errorMessage);
    };

    function onMessageArrived(message) {
      if (data.topic != message.destinationName)
        return;

      data.topic = message.destinationName;
      if (currentSettings.json_data) {
        data.msg = JSON.parse(message.payloadString);
      } else {
        data.msg = message.payloadString;
      }
      updateCallback(data);
    };

    // **onSettingsChanged(newSettings)** (required) : A public function we must implement that will be called when a user makes a change to the settings.
    self.onSettingsChanged = function(newSettings)
    {
      if (client.isConnected()) {
        client.disconnect();
      }
      data = {};
      currentSettings = newSettings;
      doConnect();
    }

    // **updateNow()** (required) : A public function we must implement that will be called when the user wants to manually refresh the datasource
    self.updateNow = function()
    {
      // Don't need to do anything here, can't pull an update from MQTT.
    }

    // **onDispose()** (required) : A public function we must implement that will be called when this instance of this plugin is no longer needed. Do anything you need to cleanup after yourself here.
    self.onDispose = function()
    {
      if (client.isConnected()) {
        client.disconnect();
      }
      client = {};
    }
    
    function doConnect() {
      var settings = {onSuccess:onConnect};
      if (!_.isEmpty(currentSettings.username)) {
        settings.userName = currentSettings.username;
        settings.password = currentSettings.password;
      }

      if (currentSettings.use_ssl) {
        settings.useSSL = currentSettings.use_ssl;
      }

      client.connect(settings);
    }

    var client = new Paho.MQTT.Client(currentSettings.server,
                    currentSettings.port, 
                    currentSettings.client_id);
    client.onConnectionLost = onConnectionLost;
    client.onMessageArrived = onMessageArrived;
    doConnect()
  }
}());
