"use strict";
(function() {
  
  var UserLibClass = function() 
  {
        // define javascript methods that will be called when widget need to be initialized or data updated. 
        // in these methods' context, beside jQuery, following variables are accessible:
        //   * this.elem       - parent DOM element 
        //   * User Properties - you can define user property on AdapterWidget in CPT:
        //                        1. select a AdapterWidget object 
        //                        2. right click in the property editor
        //                        3. choose "New User Property" menu item
        //                       NOTE: all user defined properties start with '@'. 
        //                       To read a user property's value: this.readData("@UserPropertyName");
        //                       To write a user property's value: this.writeData("@UserPropertyName", value);
        //                       To invoke an action: this.invokeAction("ActionSlotPath") or this.invokeAction("ActionSlotPath", value)
        //
        //
        // [optional] if this method defined, it should return a array of required javascript and css files
        this.requiredScripts = function() {   
          // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
          //         manually, otherwise these files cannot be deployed to device
          return ["../user_codes/toggles/css/toggles.css",
                  "../user_codes/toggles/css/themes/toggles-light.css",
                  "../user_codes/toggles/toggles.min.js"];
        };
        
        this.getReadDelayAfterWrite = function() {
          var delay = this.readData("@ReadDelayAfterWrite");
          if (typeof this.isDashboard !== 'function' || !this.isDashboard()) {
            //CPT Graphics does not support enum with customized values, 
            //so we need to convert from index to value here. Yes, it sucks 
            delay = [15000, 30000, 60000][delay];
          }
          else {
            if (delay === null || Number.isNaN(_.str.toNumber(delay)))
              delay = 15000;
            else
              delay = _.str.toNumber(delay)*1000;
          }
          return delay;
        };
        
        this.setupDataUpdateSwitch = function() {
          var _this = this;
          var delay = this.getReadDelayAfterWrite();
            
          this.enableDataUpdateAsync = _.debounce(function() { 
            _this.dataUpdate = true; 
            if (typeof _this.isDashboard !== 'function' || !_this.isDashboard())
              _this.update("@BoolValue");
              
          }, delay, false);
        };
        
        this.changeData = function(data) {
          var actionProp = data ? "@OnAction" : "@OffAction";
          
          if (!_.has(this, 'getDataPath')) {
            this.invokeAction(this.readData(actionProp), data);
            return; 
          }
          
          //try action path first
          var path = this.getDataPath(actionProp);
          if (path)
            this.invokeAction(path, data);
          else { // then try path binded to data
            path = this.getDataPath("@BoolValue");
            if (path)
              this.writeData(path, data)
            else
              console.warn("can not change data without data path configed")
          }
        };
        
        // [required] when required javascripts loaded successfully, this method will be called to initialize the widget
        this.init = function() { 
            this.loadingDone = false;
            this.dataUpdate = true;
            this.setupDataUpdateSwitch();
            this.setupUI();
            
            $(this.elem).on('settingsChanged', _.debounce(_.bind(this.setupUI, this), 200));
        
            this.update("@BoolValue");
        };
        
        this.setupUI = function() {
          var jqElem = $(this.elem);
          jqElem.empty();
          jqElem.removeClass("toggle toggle-light").removeData(['toggles', 'toggleActive', 'toggle-active']);
          jqElem.off("click");
          jqElem.width("");
          jqElem.height(jqElem.parent().height()-6);
          
          var _this = this;
          var toggleType = "compact"; 
          if (_.str.toBoolean(this.readData("@SelectToggle")))
            toggleType = "select";
          jqElem.css("text-align", "center")
                            .addClass("toggle toggle-light")
                            .toggles({
                              type: toggleType, 
                              on: _.str.toBoolean(this.readData("@BoolValue")),
                              text:{
                                on: this.readData("@OnLabel"), 
                                off: this.readData("@OffLabel")
                              }
                            });
      
          jqElem.off("toggle").on("toggle", function(e, active) {
             if (!_this.loadingDone)
               return;
      
             _this.changeData(active);
               
             _this.dataUpdate = false;
             _this.enableDataUpdateAsync();
          });
        };
        
        // [required] when user property changed, this callback method will be called
        // it is a good place to update widget with new data, you can read user property's name by:
        // this.readData("@UserPropertyName")
        this.update = function(userPropertyName) {
          if (!this.dataUpdate || userPropertyName != "@BoolValue")
            return;
        
          var boolVal = _.str.toBoolean(this.readData("@BoolValue"));
          if (!_.isBoolean(boolVal)) {
            $(this.elem).trigger("widget.error", "Out of range"); 
            return;
          } else 
            $(this.elem).trigger("widget.ok");
            
          $(this.elem).data('toggles').toggle(boolVal, false, true);
          this.loadingDone = true;
        };
        
        // [required] put possible clean up codes here
        this.cleanup = function() {
        };
        
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Toggles_Toggle_Widget',
    'display_name': 'Toggle',
    'description': 'Toggle Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@BoolValue',
        'display_name': '@BoolValue',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@OffAction',
        'display_name': '@OffAction',
        'type': 'calculated',
        'default_value': '',
        'editor': 'action'
      },
      {
        'name': '@OffLabel',
        'display_name': '@OffLabel',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@OnAction',
        'display_name': '@OnAction',
        'type': 'calculated',
        'default_value': '',
        'editor': 'action'
      },
      {
        'name': '@OnLabel',
        'display_name': '@OnLabel',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@ReadDelayAfterWrite',
        'display_name': '@ReadDelayAfterWrite',
        'type': 'option',
        'options': [{'name': 'Normal', 'value': '15'},{'name': 'Slow', 'value': '30'},{'name': 'Very Slow', 'value': '60'}],
        'default_value': '15',
        'editor': ''
      },
      {
        'name': '@SelectToggle',
        'display_name': '@SelectToggle',
        'type': 'boolean',
        'default_value': '',
        'editor': ''
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '1',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
