<?php
// vim: ts=2 sw=2

include_once "../app/db.php";
include_once "../app/base_controller.php";

class PermissionController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  protected function doAjaxGet() {
    $u = $this->curUser();
    $user_id = null;
    if (isset($_GET['user_id'])) {
      $response = array();
      $user_id = $_GET['user_id'];
      if ($user_id != $u->attr("id"))
        $this->renderAjaxError($response, L("permission denied"));
    } else {
      $response = array();
      if (!$u->isAccountManagementEnabled())
        $this->renderAjaxError($response, L("permission denied"));
    }

    $model = new DashboardPermission();
    $perms = $model->permissions($user_id);
    
    $rows = array();
    foreach($perms as $perm) {
      $rows[] = map2json($perm);
    }
    $response = "{\"data\":  [" . implode(',', $rows) . "] }";
    die($response);
  }

  protected function doAjaxPost() {
    $response = array();
    if (!$this->curUser()->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("permission denied"));

    $user_id = $_POST['user_id'];
    if (!isset($user_id)) {
      $this->renderAjaxError($response, sprintf(L("invalid %s"), "user_id"));
    }

    $u = new User();
    $u->findById($user_id);
    $error = $u->updateDashboardPermissions($_POST['perms']);
    if (!empty($error))
      $this->renderAjaxError($response, $error);
    else
      $this->renderAjaxSuccess($response);
  }
}

$controller = new PermissionController();
$controller->run();

?>
