"use strict";
$(function () {
    var loadingIndicator = $('<div class="wrapperloading"><div class="title" >Auto signin...</div><div class="loading up" ></div><div class="loading down"></div></div>');

    function showLoadingIndicator(show) {
        if (show) {
            loadingIndicator.fadeOut(0).appendTo("body").fadeIn(500);
        }
        else {
            loadingIndicator.fadeOut(500).remove();
        }
    }

    showLoadingIndicator(true);

    console.info("Signing in ...");
    $.ajax({
        url: '../app/signin.php',
        type: 'GET',
        dataType: 'json',
        data: {
            'user[name]': 'Kiosk'
        },
        success: function (data) {
            if (data.error) {
                alert('Failed to signin');
                console.error(data.error.text);
            }
        },
        error: function (jqXHR, status, error) {
            alert('Failed to signin');
        }
    }).done(function (data) {
        var authToken, shaObj1, shaObj2, token1, token2, _ref1;
        if (data.error) {
            alert('Failed to signin');
            return;
        }
        var formValues = {
            'user[name]': 'Kiosk'
        };
        authToken = data.authToken;
        _ref1 = authToken.split('_');
        token1 = _ref1[0];
        token2 = _ref1[1];
        shaObj1 = new jsSHA('Kiosk' + token1, 'TEXT');
        shaObj2 = new jsSHA(shaObj1.getHash('SHA-1', 'HEX') + token2, 'TEXT');
        formValues['user[authHash]'] = shaObj2.getHash('SHA-1', 'HEX');
        formValues['remember_me'] = false;
        return $.ajax({
            url: '../app/signin.php',
            type: 'POST',
            dataType: 'json',
            data: formValues,
            success: function (data) {
                if (data.error) {
                    alert('Failed to signin');
                    console.error(data.error.text);
                } else {
                    console.info("sign in successfully");
                    return window.location.href = data.redirectUrl;
                }
            },
            error: function (jqXHR, status, error) {
                alert('Failed to signin');
            }
        });
    });
});
