<?php
//vim: ts=2 sw=2

include_once "ini_file.php";

class Settings extends INIFile {
    public static function instance() {
      static $inst = NULL;
      if ($inst === NULL) {
        $inst = new Settings();
      }
      return $inst;
    }
    
    private function __construct() {
      $path = build_file_path(dirname(__FILE__), 'settings.ini');
      $this->load($path);
    }
    
    //helpers 
    public function session_ttl_val() {
        return intval($this->value('session', 'ttl_value', 30));
    }
    
    public function session_ttl_enabled() {
        return $this->value('session', 'ttl_enabled', 'f') == 't';
    }
    
};

?>
