<?php
// vim: ts=2 sw=2

include_once "base_controller.php";

class OSAccountManagementController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function doAjaxPost() {
    $response = array();
    $u = $this->curUser();
    $action = $_POST['action'];
    if ($action == 'changePasswd') {
      $this->changePasswd($response);
    } else {
      $this->renderAjaxError($response, sprintf(L("action %s is not supported"), $action));
    }
    $this->renderAjaxSuccess($response);
  }

  protected function ftpAccountExists($account) {
    $return_val = 0;
    $output = array();
    $account = escapeshellarg($account);
    exec("pure-pw show ${account}", $output, $return_val);
    return $return_val == 0 && count($output) > 0;
  }
  
  # debug command: curl -v -X POST -H "X-Requested-With: XMLHttpRequest" -d "action=changePasswd&account%5Bold_password%5D=123456&account%5Bnew_password%5D=Hi6868Foo" -c cookies.txt http://192.168.1.11/sdcard/cpt/app/os_account_management.php
  protected function changePasswd($response) {
    $old_password = $_POST['account']['old_password'];
    $new_password = $_POST['account']['new_password'];

    $error = User::validatePassword($new_password);
    if (!is_null($error)) {
      $this->renderAjaxError($response, sprintf(L("failed to change os account password: %s"), $error));
      return;
    }
    
    $return_val = 0;
    $platform = platformName();
    if ($platform == "FS") {
      $account = "easyio";
      $return_val = $this->doChangePasswd($account, $old_password, $new_password);
      if ($return_val != 0) {
        $message = "failed to change os account password.";
        if ($return_val == -2) {
          $message = $message . "similar to old password.";
        }
        $this->renderAjaxError($response, L($message));
        return;
      }
      $account = "webuser";
      $return_val = $this->doChangeFtpPasswd($account, $old_password, $new_password);
      if ($return_val === false)
        $return_val = $this->doChangePasswd($account, $old_password, $new_password);
    } else { //for FG+, FG
      $account = "sdcard";
      $return_val = $this->doChangePasswd($account, $old_password, $new_password);
      if ($return_val != 0) {
        $message = "failed to change os account password.";
        if ($return_val == -2) {
          $message = $message . "similar to old password.";
        }
        $this->renderAjaxError($response, L($message));
        return;
      }
      $account = "webuser";
      $return_val = $this->doChangePasswd($account, $old_password, $new_password);
    }
    
    if ($return_val == 0)
      $this->renderAjaxSuccess($response);
    else
      $this->renderAjaxError($response, L("failed to change os account password."));
  }

  protected function doChangeFtpPasswd($account, $old_password, $new_password) {
    if (!$this->ftpAccountExists($account))
      return false;

    $shell_cmd = "";
    $account = escapeshellarg($account);
    $new_password = escapeshellarg($new_password);
    $account = substr($account, 1, -1);
    $new_password = substr($new_password, 1, -1);

    if (platformName() == "FS") {
      $shell_cmd = "echo -e ${new_password}'\n'${new_password} | pure-pw passwd ${account} && pure-pw mkdb";
    } else {
      return false;
    }

    $output = array();
    $return_val = 0;
    exec($shell_cmd, $output, $return_val);
    // var_export($output);
    return $return_val;
  }

  protected function doChangePasswd($account, $old_password, $new_password) {
    $output = array();
    $return_val = 0;

    $account = escapeshellarg($account);
    $old_password = escapeshellarg($old_password);
    $new_password = escapeshellarg($new_password);
    $account = substr($account, 1, -1);
    $old_password = substr($old_password, 1, -1);
    $new_password = substr($new_password, 1, -1);
    
    exec("id ${account}", $output, $return_val);
    // if account does not exist
    if ($return_val != 0) 
      return 0;
    else
      $output = array();
    $shell_cmd = "echo -e ${old_password}'\n'${new_password}'\n'${new_password} | su -c passwd ${account};";
    exec($shell_cmd, $output, $return_val);
    if (in_array("Bad password: similar to old password", $output)) {
      return -2;
    }
    // var_export($output);
    return $return_val;
  }
}

$controller = new OSAccountManagementController();
$controller->run();

?>
