<?php
// vim: ts=2 sw=2

include_once "TinyRedisClient.php";
include_once "fi_config_file.php";
include_once "utils.php";
include_once "db.php";

class NotificationClient {

  //for every notification, the content will follow this structure: 
  //
  //  [CHECKSUM@]Key=Value,Key=Value,...|NOTIFICATION_PAYLOAD
  //  
  //  only secure message will include the checksum string at the 
  //  beginning of message
  //  for now, the supported keys: id(device id), ip, ts(timestamp), in future
  //  there might be more keys added.
  //  in theory, we can use different data encoding for payload based on
  //  different topic, but we should use json encoding as much as possible to
  //  make it consistent.
  public static function publish($topic, $payload, $secure=false) {
    if (is_null($topic) || strlen($topic) == 0 || is_null($payload)) 
      return;

    $fiConfFile = new FIConfigFile(platformName());
    $addr = $fiConfFile->get('msg_queue_addr');
    if (is_null($addr)) {
      error_log("msg queue address is not set yet, please verify if device provision is done.");
      return;
    }
    $deviceId = $fiConfFile->get("device_id");
    if (is_null($deviceId)) {
      error_log("device id is not set yet, please verify if device provision is done.");
      return;
    }
     
    $now = time();
    $ip = deviceIP(true);
    $msg = "id=$deviceId,ip=$ip,ts=$now|" . json_encode($payload);
    if ($secure) {
      $key = $fiConfFile->get('checksum_key');
      if (is_null($key)) {
        error_log("can not find checksum_key config");
        return;
      } else {
        $checksum = md5($key . "-" . $msg);
        $msg = "checksum=$checksum," . $msg;
      }
    }
    $client = new TinyRedisClient($addr);
    try {
      $client->publish($topic, $msg);
    } catch (Exception $e) {
      error_log("redis error: " . $e->getMessage());
    } finally {
      $client->close();
    }
  }
  
  public static function sendDeviceEvent($payload) {
    NotificationClient::publish("device.events", $payload, true); 
  }

  public static function sendNetworkUpdate() {
    $payload = array(
        "event" => "network_updated", 
        "mac" => macAddr()
    );
    NotificationClient::sendDeviceEvent($payload);
  }

}
?>
