<?php
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__DIR__));

include_once "notification_client.php";
include_once "base_middleware.php";

class AlarmDBMiddleware extends BaseMiddleware{
  public function postHook($url, $method, $statusCode) {
    if ($statusCode != 200 
      || $method != "POST" 
      || preg_match("#/alarmdb_exporter\.php$#i", $url) == 0)
      return true;

    if (!isset($_REQUEST["www-command"]))
      return true;

    $cmd = $_REQUEST["www-command"];
    if ($cmd == "alarmdb-add" 
      || $cmd == "alarmdb-ackn" 
      || $cmd == "alarmdb-delete" 
      || $cmd == "alarmdb-noteadd") {
      NotificationClient::publish("alarm.alarmdb", array("event" => $cmd));
    }
    return true;
  }
}

?>
