<?php
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__DIR__));

include_once "notification_client.php";
include_once "base_middleware.php";

// this middleware is for easyioAlarm, not for alarmDB
class AlarmMiddleware extends BaseMiddleware{
  public function postHook($url, $method, $statusCode) {
    if ($statusCode != 200 
      || $method != "POST" 
      || preg_match("#/alarm_controller\.php$#i", $url) == 0)
      return true;

    if (!isset($_REQUEST["action"]))
      return true;

    $action = $_REQUEST["action"];
    if ($action == "add" 
      || $action == "ackn" 
      || $action == "delete" 
      || $action == "noteadd") {
      NotificationClient::publish("alarm.events", array("event" => $action));
    }
    return true;
  }
}

?>
