<?php
//vim: ts=2 sw=2

class FIConfigFile {
  protected $platform = null;
  protected $configs = null;
  protected $modified = false;

  public function __construct($platform)
  {
    $this->platform = $platform;
    $path = $this->config_path();
    if (!is_null($path)) {
      $dir = dirname($path);
      if (!file_exists($dir)) mkdir($dir, 0777, true);
    }
    $this->load();
  }

  public function __destruct()
  {
    if ($this->modified)
      $this->save();
  }

  protected function config_path()
  {
    if ($this->platform == "FS") 
      return "/mnt/data/fi_config.json";
    else if ($this->platform == "FW")
      return "/mnt/backup/tmp/fi_config.json";
    else
      return null;
  }  

  protected function load()
  {
    $this->configs = null;

    $path = $this->config_path();
    if (is_null($path)) return false;

    if (file_exists($path)) {
      $content = file_get_contents($path);
      if (!$content) return false;
      $this->configs = json_decode($content, true);
    }
    if (is_null($this->configs))
      $this->configs = array();
    $this->modified = true;
    return true;
  }

  public function save()
  {
    $path = $this->config_path();
    if (is_null($path)) return false;
    if (is_null($this->configs)) return false;
 
    $content = json_encode($this->configs);
    if ($content === false) return false;
    $result = file_put_contents($path, $content) !== false;
    $this->modified = false;
    return $result;
  }

  public function get($key, $defaultVal=null) {
    if (is_null($this->configs))
        return $defaultVal;
    
    if (!in_array($key, array_keys($this->configs)))
        return $defaultVal;
    
    return $this->configs[$key];
  }

  public function set($key, $val)
  {
    if (is_null($this->configs)) return false;

    $this->configs[$key] = $val;
    $this->modified = true;
    return true;
  }

  public function delete($key)
  {
    if (is_null($this->configs) || is_null($key)) return false;

    unset($this->configs[$key]);
  }
  
  public function keys() {
    return array_keys($this->configs);
  }
}

?>
