<?php 
//vim: ts=2 sw=2

include_once "base_controller.php";
include_once "fi_config_file.php";
include_once "jwt_key_store.php";
include_once "manifests/device_data_collector.php";

class DeviceManifestController extends BaseController {
  protected $data_file  = null;
  protected $state_file = null;

  function __construct() {
    $cur_path = dirname(__FILE__);
    $this->data_file = build_file_path($cur_path, "manifests", "device.manifest");
    $this->state_file = build_file_path($cur_path, "manifests", "collector.running");
  }
  protected function signinRequired() {
    return false;
  }

  protected function fetch_from_cache() {
    if (!file_exists($this->data_file))
      return null;

    $now = time();
    # try to update data file when it's too old
    if (filemtime($this->data_file) + 1800 < $now) {
      # only start to update data file when:
      #  1. there is no state file
      #  2. state file is too old
      if (file_exists($this->state_file)) {
        if (filemtime($this->state_file) + 600 < $now) {
          unlink($this->state_file);
          return null;
        }
      } else 
        return null;
    }

    $content = file_get_contents($this->data_file);
    return json_decode($content, true);
  }

  protected function cache_data($data) {
    file_put_contents($this->data_file, json_encode($data));
  }

  public function collect_data() {
    $data = $this->fetch_from_cache();
    if (!is_null($data))
      return $data;

    error_log("start to collect device manifest data...");
    $collector = new DeviceDataCollector();
    touch($this->state_file);
    $data = $collector->run();
    unlink($this->state_file);

    $this->cache_data($data);
    // $time_cost = floatval(number_format($timer->elapsed(), 2));
    error_log("finish collecting device manifest data");
    return $data;
  }

  protected function generateTunnelChecksum() {
    $pname = platformName();
    $store = new JWTKeyStore($pname);
    $pubKey = $store->pub_for("EIO_FI");
    if (empty($pubKey)) return null;

    $fiConfFile = new FIConfigFile($pname);
    $deviceId = $fiConfFile->get('device_id');
    $checksumKey = $fiConfFile->get('checksum_key');
    return md5($pubKey . '-' . $deviceId . '-' . $checksumKey);
  }

  protected function verifyTunnel() {
    $linked = null;
    if (isset($_GET['tunnel_checksum'])) {
      $checksum = $_GET['tunnel_checksum'];
      $localChecksum = $this->generateTunnelChecksum();
      $linked = $checksum === $localChecksum;
    }
    return $linked;
  }

  public function doAjaxGet() {
    $result = $this->collect_data();
    $linked = $this->verifyTunnel();
    if (!is_null($linked)) {
      $result['metadata']['FI_linked'] = $linked;
    }

    $this->renderAjaxSuccess2($result);
  }
}

$controller = new DeviceManifestController();
$controller->run();

// $manifests = $controller->collect_data();
// $os  = $manifests['os'];
// $firmware = $manifests['firmware'];
// $services = $manifests['services'];
 
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php echo Config::$webPageTitle ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <script type="text/javascript" src="<?php A('../js/renderjson.js') ?>"></script>
  </head>
  <body>
    <p class="text-center" style="font-size: 30px">Device Manifest Data</p>
    <div id="container" class="container" style="font-size: 28px">
    </div>

    <script language="javascript" type="text/javascript">
      "use strict";
      let json_str = `<?php echo json_encode($controller->collect_data()) ?>`;
      // renderjson.set_icons('+', '-');
      renderjson.set_show_by_default(true);
      let elem = renderjson(JSON.parse(json_str));
      document.getElementById("container").appendChild(elem);
    </script>
  </body>
</html>
