<?php
//vim: ts=2 sw=2

include_once "utils.php";

class RemoteRestoreController {
  public function run() {
    sync();
    $name = $_GET['name'];
    $cptPath = $_GET['cptPath'];
    $withHistoryDB = $_GET['withHistoryDB'] != '0';
    $type = $_GET['type'];

    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    $realCptPath = build_file_path($rootPath, $cptPath);
    $error = doRestore($name, $realCptPath, $withHistoryDB, $type);
    
    if (!empty($error))
      error_log("restore error: " . $error);
    else
      setupIndex($rootPath, $realCptPath, true);

    cleanupGhostScripts();
    sync();

    die($error);
  }
}

$controller = new RemoteRestoreController();
$controller->run();

?>
