<?php
//vim: ts=2 sw=2

include_once "utils.php";

class RemoteDeleteController {
  public function run() {
    $error = "";
    if (!isset($_GET['backups']) || !isset($_GET['backupStorageTypes'])) {
        $error = "required parameter missing";
        error_log($error);
        die($error);
    }
    
    $backups = $_GET['backups'];
    $storageTypes = $_GET['backupStorageTypes'];
    $names = explode(",", $backups);
    $types = explode(",", $storageTypes);
    
    if (count($names) != count($types)) {
        $error = "backup name list does not match storage type list.";
        error_log($error);
        die($error);
    }

    if ($names)
      for($i=0; $i<count($names); ++$i) {
        $name = $names[$i];
        $type = $types[$i];
        $error = doDeleteBackup($name, $type);
        if (!empty($error))
          break;
      }

    if (!empty($error))
      error_log("delete backups '" . $backups . "' error: " . $error);
    cleanupGhostScripts();

    die($error);
  }
}

$controller = new RemoteDeleteController();
$controller->run();

?>
