<?php
//vim: ts=2 sw=2
//FIXME: this file should be deprecated soon, move most of functions into
//plugin, use graphic folder instead of two copies of codes in cpt graphics and
//fg_utility_app

include_once "feature_control.php";
include_once "base_controller.php";

class UtilityController extends BaseController {

  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }

  public function listBackups() {
    return doListBackups(false); 
  }

  public function doGet() {
    if (!$this->isSignedin())
      $this->redirect($this->makeUrl("app/signin.php"));
  }
  
  public function doAjaxPost() {
    $response = array();
    $action = $_POST['action'];
    if ($action == 'restore')
      $this->restore();
    else if ($action == 'reboot')
      $this->reboot();
    else
      $this->renderAjaxError($response, "invalid action: " . $action);
  }

  protected function restore() {
    $response = array();
    $data = $_POST['data'];
    $name = $data['name'];
    if (array_key_exists('type', $data))
      $type = $data['type'];
    else
      $type = "sdcard";

    if (array_key_exists('withNetworkConf', $data))
      $withNetworkConf = $data['withNetworkConf'] === 'true';
    else
      $withNetworkConf = false;

    $error = doRestore($name, NULL, true, $type, $withNetworkConf);
    if (empty($error))
    {
      $rootPath = $_SERVER['DOCUMENT_ROOT'];
      $cptBasePath = build_file_path($rootPath, 'sdcard', 'cpt');
      //set up graphic as root index
      setupIndex($rootPath, $cptBasePath, true);
      $this->renderAjaxSuccess(array('resultCode'=> 0));
    }
    else
      $this->renderAjaxError($response, $error);
  }
  
  protected function reboot() {
    $error = doReboot(true);
    if (empty($error))
      $this->renderAjaxSuccess(array('resultCode'=> 0));
    else
      $this->renderAjaxError($response, $error);
  }
}

$controller = new UtilityController();
$controller->run();

?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Controller Utility</title>

    <link rel="stylesheet" href="../css/pure-min.css">
    <!--[if lte IE 8]>
        <link rel="stylesheet" href="css/grids-responsive-old-ie-min.css">
    <![endif]-->
    <!--[if gt IE 8]><!-->
        <link rel="stylesheet" href="../css/grids-responsive-min.css">
    <!--<![endif]-->

    <link rel="stylesheet" href="../css/utility.css">
</head>

<body>
  <div id="layout">
    <div id="signoutDiv" style="float: right;">
      <a href="signout.php">
        <!-- <i class="fa fa&#45;sign&#45;out"></i> -->
        Sign out
      </a>
    </div>
    <div class="clear"></div>
    <div class="pure-g">
      <div class="pure-u-2-24"></div>
      <div class="pure-u-20-24">
        <div>
          <h3>Restore
          <small>sedona app & graphics</small>
          <h3>
        </div>
        <div id="msgDiv"></div>

<?php 
      $backups = $controller->listBackups();
      if (!empty($backups)) {
?>
        <?php
          $backups_in_flash = array();
          $backups_in_sdcard = array();
          
          foreach($backups as $b) {
            if (!isset($b['type']))
              continue;
            if ($b['type'] == 'flash') 
              $backups_in_flash[] = $b;
            else if ($b['type'] == 'sdcard')
              $backups_in_sdcard[] = $b;
          }
        ?>

        <?php if (!empty($backups_in_flash)) { ?>
        <h4 style="margin-bottom:8px;">Backups in Flash</h4>
        <table class="backupList" class="pure-table" data-type="flash">
          <tbody>
          <?php foreach($backups_in_flash as $index=>$backup) {
            if ($index%2 == 0)
              echo <<<EOS
            <tr class="pure-table-odd">
EOS;
            else
              echo <<<EOS
            <tr>
EOS;
            echo <<<EOS
                <td class="backup-name">${backup['name']}</td>

EOS;
            if ($backup['withNetworkConf'] == '1')
              echo <<<EOS
                <td><input class="with-network-conf" type="checkbox"><label>Network Config</label></td>
EOS;
            else
              echo "<td></td>";
                
            echo <<<EOS
                <td>
                  <button class="pure-button button-secondary">
                  <!-- <i class="fa fa-play"></i> -->
                  Restore
                  </button>
                </td>
            </tr>
EOS;
      } ?>
          </tbody>
        </table>
        <?php } ?>

        <?php if (!empty($backups_in_sdcard)) { ?>
        <h4 style="margin-top:50px; margin-bottom:8px;">Backups in SDCard</h4>
        <table class="backupList" class="pure-table" data-type="sdcard">
          <tbody>
          <?php foreach($backups_in_sdcard as $index=>$backup) {
            if ($index%2 == 0)
              echo <<<EOS
            <tr class="pure-table-odd">
EOS;
            else
              echo <<<EOS
            <tr>
EOS;
            echo <<<EOS
                <td class="backup-name">${backup['name']}</td>
EOS;
            if ($backup['withNetworkConf'] == '1')
              echo <<<EOS
                <td><input class="with-network-conf" type="checkbox"><label>Network Config</label></td>
EOS;
            else
              echo "<td></td>";

            echo <<<EOS
                <td>
                  <button class="pure-button button-secondary">
                  <!-- <i class="fa fa-play"></i> -->
                  Restore
                  </button>
                </td>
            </tr>
EOS;
      } ?>
          </tbody>
        </table>
        <?php } ?>

<?php } else { ?>
        <div>
          <h3>No backup available.</h3>
        </div>
<?php } ?>
      </div>
      <div class="pure-u-2-24"></div>
    </div>


    <?php if (FeatureControl::instance()->isEnabled("FirmwareUpgrade")) { ?>
    <div class="pure-g" style="background:#b3d8e9; margin-top:50px; padding:10px 0 40px 0;">
      <div class="pure-u-2-24"></div>
      <div id="firmware_upgrade_panel" class="pure-u-20-24">
        <div>
          <h3>Firmware Upgrade
          <small></small>
          <h3>
        </div>

        <form id="firmware_upgrade_form" class="pure-form" action="upgrade_firmware.php" method="post" enctype="multipart/form-data">
          <fieldset>
            <div class="alert hide"></div>

            <label for="inputFirmwareFile">Firmware File:</label>
            <input type="file" id="inputFirmwareFile" name="firmwareFile">
            <div id="firmware-upgrade-progress" class="progress progress-info progress-striped">
              <div class="bar" style="width: 0%"></div>
            </div>
            <button type="submit" class="pure-button pure-button-primary upgrade-button">Upgrade</button>
          </fieldset>
        </form>

      </div>
      <div class="pure-u-2-24"></div>
    </div>
    <?php } ?>

  </div>

  <script language="javascript" type="text/javascript">
    window.firmwareFileName = '<?php echo firmwareFileName() ?>';
  </script>

  <script type="text/javascript" src="../js/jquery-1.10.0.min.js"></script>
  <script type="text/javascript" src="../js/underscore-min.js"></script>
  <script type="text/javascript" src="../js/underscore.string.min.js"></script>
  <script type="text/javascript" src="../js/spin.min.js"></script>
  <script type="text/javascript" src="../js/jquery.form.min.js"></script>

  <script type="text/javascript" src="../js/utility.js"></script>

</body>
</html>
