<?php
//vim: ts=2 sw=2
include_once "app/utils.php";

if (platformName() == "FW") {
    $controllerName = "FW";
    $ipEnabled = false;
    $mstpEnabled = false;
} else if (platformName() == "FS") {
    $controllerName = "FS-32";
    $ipEnabled = true;
    $mstpEnabled = true;
} else {
    $controllerName = "FG-32+";
    $ipEnabled = true;
    $mstpEnabled = true;
}

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>EasyIO <?php echo $controllerName ?> BTL</title>

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>
  <body>
    <div class="container">
    	<p class="h2 text-center"><span style="color:blue;">Easy</span><span style="color:red;">IO</span> <?php echo $controllerName ?> BTL</p>
			<form class="form-horizontal" role="form" >
				<div class="row">
					<p class="h3 col-sm-4 text-right">Device Configuration:</p>
				</div>
				<div class="form-group">
					<label for="inputObjId" class="col-sm-4 control-label">Object Identifier:</label>
					<div class="col-sm-4">
						<input type="number" class="form-control" id="inputObjId" min="0" max="4194302" required autofocus>
					</div>
          <div class="col-sm-4 help-block text-muted">(Max Id=4194302)</div>
				</div>
				<div class="form-group">
					<label for="inputObjName" class="col-sm-4 control-label">Object Name:</label>
					<div class="col-sm-4">
						<input type="text" class="form-control" id="inputObjName" maxlength="64" required>
					</div>
          <div class="col-sm-4 help-block text-muted">(Max length=64)</div>
				</div>

<?php if ($ipEnabled) { ?>
			  <div class="checkbox" style="margin-bottom: 7px; margin-top: -10px;" >
					<div class="col-sm-offset-4 col-sm-4">
						<label>
							<input type="checkbox" id="inputIPEnabled">Enable IP
						</label>
					</div>
				</div>
				<div class="form-group">
					<label for="inputIPAddress" class="col-sm-4 control-label">IP Address:</label>
					<div class="col-sm-4">
						<input type="text" class="form-control" id="inputIPAddress">
					</div>
				</div>
<?php } ?>
<?php if ($mstpEnabled) { ?>
			  <div class="checkbox" style="margin-bottom: 7px; margin-top: -15px;" >
					<div class="col-sm-offset-4 col-sm-4">
						<label>
							<input type="checkbox" id="inputMSTPEnabled">Enable MSTP
						</label>
					</div>
				</div>
				<div class="form-group" style="margin-bottom: 5px;">
					<label for="inputMSTPAddress" class="col-sm-4 control-label">MSTP MAC Address:</label>
					<div class="col-sm-4">
						<input type="number" class="form-control" id="inputMSTPAddress" min="0" max="127">
					</div>
				</div>
				<div class="form-group">
					<label for="inputMSTPBaudRate" class="col-sm-4 control-label">MSTP Baud Rate:</label>
					<div class="col-sm-4">
						<select id="inputMSTPBaudRate" class="form-control" >
							<option value="0">9600</option>
							<option value="1">19200</option>
							<option value="2">38400</option>
							<option value="3">76800</option>
						</select>
					</div>
				</div>
<?php } ?>
				
				<div class="row">
					<p class="h3 col-sm-4 text-right">Register Foreign-Device:</p>
				</div>
				<div class="form-group">
					<label for="inputBBMDAddress" class="col-sm-4 control-label">BBMD Address:</label>
					<div class="col-sm-4">
						<input type="text" class="form-control" id="inputBBMDAddress" placeholder="(Blank or 0.0.0.0 to Disable)">
					</div>
				</div>
				<div class="form-group">
					<label for="inputTTL" class="col-sm-4 control-label">Time-To-Live:</label>
					<div class="col-sm-4">
            <div class="input-group">
              <input type="number" class="form-control" id="inputTTL" min="0" max="65535">
              <div class="input-group-addon">Seconds</div>
            </div>
					</div>
          <div class="col-sm-4 help-block text-muted">(Max val=65535)</div>
				</div>

				<div class="form-group" style="margin-top: 35px;">
					<div class="col-sm-offset-4 col-sm-8">
						<button id="submitBtn" type="submit" class="btn btn-primary" style="margin-right: 10px;">Submit</button>
						<button id="saveBtn" type="button" class="btn btn-success" style="margin-right: 10px;">Save</button>
						<button id="refreshBtn" type="button" class="btn btn-default" style="margin-right: 30px;">Refresh</button>
						<button id="restoreBtn" type="button" class="btn btn-danger">Restore Default App</button>
					</div>
				</div>
			</form>
    </div>

    <script src="js/jquery-1.10.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/spin.min.js"></script>
    
    <script language="javascript" type="text/javascript">
      var spinner = new Spinner();
      var oldIpAddress = null;

      var ipRegex = /^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}$/;
      function validate() {
        var failed = false;
        $(".has-error").removeClass("has-error");

        var objId = $("#inputObjId").val();
        if (/^[1-9][0-9]*$/.test(objId) && parseInt(objId) <= 4194302) {
          $("#inputObjId").parents(".form-group").removeClass("has-error");
        } else {
          failed = true;
          $("#inputObjId").parents(".form-group").addClass("has-error");
        }
        
        var objName = $("#inputObjName").val();
        // if (/^[-\w/@+=#%~]+$/.test(objName) && objName.length <= 64)
        if (objName.length <= 64 && /^[ -~]+$/.test(objName))
          $("#inputObjName").parents(".form-group").removeClass("has-error");
        else {
          failed = true;
          $("#inputObjName").parents(".form-group").addClass("has-error");
        }
        
<?php if($ipEnabled) { ?>
        var ipEnabled = $('#inputIPEnabled').prop('checked');
        if (ipEnabled) {
          var ipAddress = $("#inputIPAddress").val();
          if (ipRegex.test(ipAddress))
            $("#inputIPAddress").parents(".form-group").removeClass("has-error");
          else {
            failed = true;
            $("#inputIPAddress").parents(".form-group").addClass("has-error");
          }
        }
<?php } ?>

<?php if($mstpEnabled) { ?>
        var mstpEnabled = $('#inputMSTPEnabled').prop('checked');
        if (mstpEnabled) {
          var mstpAddress = $("#inputMSTPAddress").val();
          if (/^[0-9]+$/.test(mstpAddress) && parseInt(mstpAddress) <= 127)
            $("#inputMSTPAddress").parents(".form-group").removeClass("has-error");
          else {
            failed = true;
            $("#inputMSTPAddress").parents(".form-group").addClass("has-error");
          }

          var baudRate = $("#inputMSTPBaudRate").val();
          if (/^[0-9]+$/.test(baudRate))
            $("#inputMSTPBaudRate").parents(".form-group").removeClass("has-error");
          else {
            failed = true;
            $("#inputMSTPBaudRate").parents(".form-group").addClass("has-error");
          }
        }
<?php } ?>
        
        var bbmdAddress = $("#inputBBMDAddress").val();
        if (bbmdAddress.length == 0 || ipRegex.test(bbmdAddress))
          $("#inputBBMDAddress").parents(".form-group").removeClass("has-error");
        else {
          failed = true;
          $("#inputBBMDAddress").parents(".form-group").addClass("has-error");
        }
        
        var ttl = $("#inputTTL").val();
        if (/^[0-9]+$/.test(ttl) && parseInt(ttl) <= 65535)
          $("#inputTTL").parents(".form-group").removeClass("has-error");
        else {
          $("#inputTTL").parents(".form-group").addClass("has-error");
          failed = true;
        }

        return !failed;
      };

      function initUI(data) {
        for(var i=0; i< data.length; ++i) {
          var path = data[i].path;
          if (path == "/EasyIO/BACnetS") {
            var slots = data[i].slots;
            for(var j=0; j<slots.length; ++j) {
              var name = slots[j].name;
              var value = slots[j].value;
<?php if ($ipEnabled) { ?>
              if (name == "ipEnabled") 
                $("#inputIPEnabled").prop("checked", value=="true");
              else if (name == "ip") {
                $("#inputIPAddress").val(value);
                oldIpAddress = value;
              }
<?php } else { ?>
              if (name == "ipEnabled" || name == "ip")
                continue;
<?php } ?>
<?php if ($mstpEnabled) { ?>
              else if (name == "mstpEnabled")
                $("#inputMSTPEnabled").prop("checked", value=="true");
              else if (name == "mstpMAC")
                $("#inputMSTPAddress").val(value);
              else if (name == "mstpBaudRate")
                $("#inputMSTPBaudRate").val(value);
<?php } ?>
              else if (name == "bbmdIp")
                $("#inputBBMDAddress").val(value);
              else if (name == "bbmdTTL")
                $("#inputTTL").val(value);
            }
          } else if (path == "/EasyIO/BACnetS/BACServ") {
            var slots = data[i].slots;
            for(var j=0; j<slots.length; ++j) {
              var name = slots[j].name;
              var value = slots[j].value;
              if (name == "objectId")
                $("#inputObjId").val(value);
              else if (name == "serverName")
                $("#inputObjName").val(value);
            }
          }
        }
        updateUI();
      };

      function loadData() {
        var url = "app/data_api.php?url=/app/objects/EasyIO/BACnetS~/EasyIO/BACnetS/BACServ";
        $.ajax({
          type: "GET",
          url: url,
          dataType: "json",
          success: function(data) {
            if (data==null || data.response==null 
                || data.response.data==null || data.response.data.length==0)
              alert("invalid response");
            else
              initUI(data.response.data);
          },
          error: function() {
            alert("failed to load BACnet data");
          }
        });
      };

      function updateUI() {
<?php if ($ipEnabled) { ?>
        var ipEnabled = $('#inputIPEnabled').prop('checked');
        $("#inputIPAddress").prop("disabled", !ipEnabled);
<?php } ?>

<?php if ($mstpEnabled) { ?>
        var mstpEnabled = $('#inputMSTPEnabled').prop('checked');
        $("#inputMSTPAddress").prop("disabled", !mstpEnabled);
        $("#inputMSTPBaudRate").prop("disabled", !mstpEnabled);
<?php } ?>
      };
      
      function addSlot(path, type, value, prefix) {
        if (prefix == null)
          prefix = "/app/objects/EasyIO";
        return {path: prefix + path, type: type, 
                value: value, slotType: "property"};
      };

      function postData() {
        var slots = [];
        slots.push(addSlot("/BACnetS/BACServ.objectId", "int",
              $("#inputObjId").val()));
        slots.push(addSlot("/BACnetS/BACServ.serverName", "Buf",
              $("#inputObjName").val()));

<?php if ($ipEnabled) { ?>
        var ipEnabled = $('#inputIPEnabled').prop('checked');
        slots.push(addSlot("/BACnetS.ipEnabled", "bool", 
              ipEnabled));

        var ipChanged = $("#inputIPAddress").val() != oldIpAddress;
        if (ipEnabled && ipChanged) {
          var newIpAddress = $("#inputIPAddress").val();
          slots.push(addSlot("/app/objects/service/IP.newIpAddress", "Buf",
                newIpAddress, ""));
          oldIpAddress = newIpAddress;
        }
<?php } ?>

<?php if ($mstpEnabled) { ?>
        var mstpEnabled = $('#inputMSTPEnabled').prop('checked');
        slots.push(addSlot("/BACnetS.mstpEnabled", "bool",
              mstpEnabled));
        if (mstpEnabled) {
          slots.push(addSlot("/BACnetS.mstpMAC", "int", 
                $('#inputMSTPAddress').val()));
          slots.push(addSlot("/BACnetS.mstpBaudRate", "int",
                $("#inputMSTPBaudRate").val()));
        }
<?php } ?>

        var bbmdIP = $("#inputBBMDAddress").val();
        slots.push(addSlot("/BACnetS.bbmdEnable", "bool", 
              bbmdIP != "" && bbmdIP!="0.0.0.0"));

        slots.push(addSlot("/BACnetS.bbmdIp", "Buf", bbmdIP));
        slots.push(addSlot("/BACnetS.bbmdTTL", "int",
              $("#inputTTL").val()));

        $.ajax({
          type: "POST",
          url: "app/data_api.php",
          dataType: "json",
          data: {
            "slots": slots
          }
        });

<?php if ($ipEnabled) { ?>
        if (ipChanged)
          setTimeout(function() {
            location.href = location.protocol + "//" + oldIpAddress + location.pathname;
          }, 10*1000);
<?php } ?>
      };

      function doAction(action) {
        $.ajax({
          type: "POST",
          url: "app/data_api.php",
          dataType: "json",
          data: {
            "slots": [{
              path: "/app/objects/." + action,
              type: "void", 
              value: "", 
              slotType: "action"
            }]
          }
        });
      }

      $(document).ready(function() {
        $(document).ajaxSend(function() {
          spinner.spin($("form")[0]);
        }).ajaxComplete(function() {
          spinner.stop($("form")[0]);
        });

<?php if ($ipEnabled) { ?>
        $("#inputIPEnabled").change(updateUI);
<?php } ?>

<?php if ($mstpEnabled) { ?>
        $("#inputMSTPEnabled").change(updateUI);
<?php } ?>

        $("#saveBtn").click(function() {
          doAction("save");
        });
        $("#refreshBtn").click(function() {
          $(".has-error").removeClass("has-error");
          loadData();
        });
        $("#submitBtn").click(function(e) {
          e.preventDefault();
          if (!validate())
            return;
          postData();
        });
        $("#restoreBtn").click(function(e) {
          $.ajax({
            type: "POST",
            url: "app/data_api.php",
            dataType: "json",
            data: {
              "action": "restore"
            }
          });
        });
        
        updateUI();
        loadData();
      });

    </script>
  </body>
</html>
