<?php
//vim: ts=2 sw=2

include_once "base_controller.php";
include_once "UDPClient.class.php";

class DataAPIController extends BaseController { 
  public $host, $port;
  private $client;

  function __construct() {
    $this->host = "127.0.0.1";
    //$this->port = "88"; // for weblet
    $this->port = "1001"; // for udp service

    $this->client = NULL;
  }

  function forwardHostName() {
    return $this->host . ":" . $this->port;
  }

  function getClient() {
    if (is_null($this->client))
    {
      $this->client = new UDPClient($this->host, $this->port);
      //$this->client = new HttpClient($this->forwardHostName());
      $this->client->setDebug(false);
    }
    return $this->client;
  }

  protected function signinRequired() {
    return false;
  }

  public function doAjaxGet() {
    $newUrl = $this->forwardURL();
    $client = $this->getClient();
    if ($client->get($newUrl)) {
      $content = $client->getContent();
      if (empty($content))
          die('{"response": ""}');
      else
          die('{"response": ' . $content . '}');
    }
    else
    {
      // die('An error occurred: ' . $client->getError());
      die('{"error": {"text": "failed to get data: ' . $client->getError() . '"}}');
    }
  }
  
  protected function saveApp($client) {
    $client->invokeAction("/app/objects/.save", "void", "");
  }
  
  protected function restartSvm($client) {
    $client->invokeAction("/app/objects/.restart", "void", "");
  }
  
  protected function changeSlot($client, $slotType, $path, $type, $value) {
    if ($slotType == 'action') {
      $client->invokeAction($path, $type, $value);
    }
    elseif ($slotType == 'property') {
      $client->writeProperty($path, $type, $value);
    }
  }

  public function doAjaxPost() {
    $response = array();
    
    $client = $this->getClient();

    if (isset($_POST['action'])) {
      $action = $_POST['action'];
      if ($action == "restore") {
        restoreDefaultApp();
        $this->restartSvm($client);
      }
    } else {
      $ip_changed = false;
      foreach($_POST['slots'] as $slot) {
        if ($slot['path'] == '/app/objects/service/IP.newIpAddress')
          $ip_changed = true;
        $this->changeSlot($client, $slot['slotType'], $slot['path'], 
          $slot['type'], $slot['value']);
      }
      $this->saveApp($client);
      if ($ip_changed)
        $this->restartSvm($client);
    }
    $this->renderAjaxSuccess(array('resultCode' => 0));
  }

  function forwardURL() {
    $path = $_GET['url'];
    return $path;
    //if($_SERVER['QUERY_STRING']=="")
    //return $path;
    //else
    //return $path. "?" . $_SERVER['QUERY_STRING'];
  }
}

$controller = new DataAPIController();
$controller->run();

?>
