/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.analysis.ControlFlowGraph;
import sedonac.analysis.DeadCodeAnalysis;
import sedonac.analysis.DefiniteAssignmentAnalysis;
import sedonac.analysis.UnusedCodeAnalysis;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;

public class StaticAnalysis
extends CompilerStep {
    public StaticAnalysis(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  Static Analysis");
        new UnusedCodeAnalysis(this.compiler).run();
        this.analyzeMethods();
        this.quitIfErrors();
    }

    private void analyzeMethods() {
        TypeDef[] typeDefArray = this.compiler.ast.types;
        for (int i = 0; i < typeDefArray.length; ++i) {
            MethodDef[] methodDefArray = typeDefArray[i].methodDefs();
            for (int j = 0; j < methodDefArray.length; ++j) {
                ControlFlowGraph controlFlowGraph = ControlFlowGraph.make(methodDefArray[j]);
                new DeadCodeAnalysis(this.compiler, controlFlowGraph).run();
                new DefiniteAssignmentAnalysis(this.compiler, controlFlowGraph).run();
            }
        }
    }
}

