/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import sedona.Depend;
import sedona.Env;
import sedona.util.VendorUtil;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.SourceFile;
import sedonac.ast.DependDef;
import sedonac.ast.IncludeDef;
import sedonac.ast.KitDef;
import sedonac.ast.NativeDef;
import sedonac.namespace.NativeId;

public class InitKitCompile
extends CompilerStep {
    File kitFile;
    File kitDir;
    XElem xml;

    public InitKitCompile(Compiler compiler) {
        super(compiler);
        this.kitFile = compiler.input;
        this.kitDir = this.kitFile.getParentFile();
        this.xml = compiler.xml;
    }

    @Override
    public void run() {
        try {
            this.log.debug("  InitKitCompile");
            this.parseKitDef();
            this.findSourceFiles();
            this.checkVendor();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private void checkVendor() {
        KitDef kitDef = this.compiler.ast;
        Location location = new Location(this.kitFile);
        String string = kitDef.name;
        String string2 = kitDef.vendor;
        if (string2.equals("Tridium")) {
            return;
        }
        try {
            VendorUtil.checkVendorName((String)string2);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage(), location);
        }
        if (!string.toLowerCase().startsWith(string2.toLowerCase())) {
            throw this.err("Kit name '" + string + "' must be prefixed with vendor name '" + string2 + "'", location);
        }
    }

    private void parseKitDef() {
        KitDef kitDef = new KitDef(new Location(this.kitFile));
        kitDef.name = this.xml.get("name");
        kitDef.vendor = this.xml.get("vendor");
        kitDef.description = this.xml.get("description");
        kitDef.includeSource = this.xml.getb("includeSource", false);
        kitDef.doc = this.xml.getb("doc", false);
        Version version = this.compiler.kitVersion;
        if (version == null) {
            version = this.xml.getVersion("version", null);
        }
        if (version == null) {
            version = Version.parse((String)Env.getProperty((String)"buildVersion", null));
        }
        if (version == null) {
            throw this.err("Kit version isn't defined", kitDef.loc);
        }
        kitDef.version = version;
        this.parseDepends(kitDef, this.xml.elems("depend"));
        this.parseIncludes(kitDef, this.xml.elems("include"));
        this.parseNatives(kitDef, this.xml.elems("native"));
        this.compiler.ast = kitDef;
    }

    private void parseDepends(KitDef kitDef, XElem[] xElemArray) {
        int n;
        kitDef.depends = new DependDef[xElemArray.length];
        for (n = 0; n < xElemArray.length; ++n) {
            XElem xElem = xElemArray[n];
            kitDef.depends[n] = new DependDef(new Location(xElem), xElem.getDepend("on"));
        }
        n = kitDef.name.equals("sys") ? 1 : 0;
        for (int i = 0; i < kitDef.depends.length; ++i) {
            if (!kitDef.depends[i].depend.name().equals("sys")) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            this.err("Must declare dependency on 'sys'", new Location(this.xml != null ? this.xml : this.xml));
        }
    }

    private void parseIncludes(KitDef kitDef, XElem[] xElemArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < kitDef.depends.length; ++i) {
            hashSet.add(kitDef.depends[i].depend.name());
        }
        HashSet<Depend> hashSet2 = new HashSet<Depend>();
        kitDef.includes = new IncludeDef[xElemArray.length];
        for (int i = 0; i < xElemArray.length; ++i) {
            XElem xElem = xElemArray[i];
            Location location = new Location(this.xml.location().file, xElem.line());
            IncludeDef includeDef = kitDef.includes[i] = new IncludeDef(new Location(xElem), xElem.getDepend("from"));
            if (hashSet.contains(includeDef.depend.name())) {
                this.err("Cannot include and depend on the same kit: '" + includeDef.depend.name() + "'", location);
            }
            if (!hashSet2.add(includeDef.depend)) {
                this.err("Duplicate <include> directive for kit: '" + includeDef.depend + "'", location);
            }
            XElem[] xElemArray2 = xElem.elems("type");
            for (int j = 0; j < xElemArray2.length; ++j) {
                includeDef.typeToSource.put(xElemArray2[j].get("name"), null);
            }
        }
    }

    private void parseNatives(KitDef kitDef, XElem[] xElemArray) {
        ArrayList<NativeDef> arrayList = new ArrayList<NativeDef>();
        for (int i = 0; i < xElemArray.length; ++i) {
            XElem xElem = xElemArray[i];
            String string = xElem.get("qname");
            NativeId nativeId = NativeId.parse(new Location(xElem), xElem.get("id"));
            if (nativeId == null) {
                throw new XException("Invalid id format", xElem);
            }
            arrayList.add(new NativeDef(new Location(xElem), string, nativeId));
        }
        kitDef.natives = arrayList.toArray(new NativeDef[arrayList.size()]);
    }

    void findSourceFiles() {
        int n;
        XElem[] xElemArray = this.xml.elems("source");
        if (xElemArray.length == 0) {
            throw this.err("Must specify at least one <source> element", new Location(this.xml));
        }
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < xElemArray.length; ++n) {
            this.findSourceFiles(arrayList, xElemArray[n]);
        }
        this.compiler.sourceFiles = arrayList.toArray(new SourceFile[arrayList.size()]);
        if (this.compiler.log.isDebug()) {
            for (n = 0; n < this.compiler.sourceFiles.length; ++n) {
                this.log.debug("    " + this.compiler.sourceFiles[n]);
            }
        }
    }

    void findSourceFiles(ArrayList arrayList, XElem xElem) {
        String string = xElem.get("dir");
        File file = new File(this.kitFile.getParentFile(), string);
        if (!file.exists() || !file.isDirectory()) {
            throw this.err("Unknown source directory '" + string + "'", new Location(xElem));
        }
        boolean bl = this.isTestonly(xElem);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.getName().endsWith(".sedona")) continue;
            try {
                SourceFile sourceFile = new SourceFile();
                sourceFile.file = file2.getCanonicalFile();
                sourceFile.testOnly = bl;
                arrayList.add(sourceFile);
                continue;
            }
            catch (IOException iOException) {
                throw this.err("Cannot map to canonical filename: " + file2, new Location(xElem), (Throwable)iOException);
            }
        }
    }

    private boolean isTestonly(XElem xElem) {
        Location location = new Location(xElem);
        boolean bl = false;
        try {
            bl = xElem.getb("testonly");
            try {
                boolean bl2 = xElem.getb("test");
                this.err("Attributes 'test' and 'testonly' cannot both be present. Use 'testonly'.", location);
            }
            catch (XException xException) {}
        }
        catch (XException xException) {
            try {
                bl = xElem.getb("test");
                this.warn("The 'test' attribute is deprecated. Use 'testonly' instead. ", location);
            }
            catch (XException xException2) {
                // empty catch block
            }
        }
        return bl;
    }
}

