/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.ir.IrType;
import sedonac.namespace.Method;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

public class Inherit
extends CompilerStep {
    public Inherit(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  Inherit");
        for (int i = 0; i < this.compiler.kits.length; ++i) {
            IrType[] irTypeArray = this.compiler.kits[i].types;
            for (int j = 0; j < irTypeArray.length; ++j) {
                this.inherit(irTypeArray[j]);
            }
        }
        if (this.compiler.ast != null) {
            this.walkAst(1);
        }
        this.quitIfErrors();
    }

    @Override
    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        this.inherit(typeDef);
    }

    private void inherit(Type type) {
        if (type.base() == null) {
            return;
        }
        Slot[] slotArray = type.base().slots();
        for (int i = 0; i < slotArray.length; ++i) {
            this.inheritSlot(type, slotArray[i]);
        }
        if (type instanceof TypeDef) {
            TypeDef typeDef = (TypeDef)type;
            SlotDef[] slotDefArray = typeDef.slotDefs();
            for (int i = 0; i < slotDefArray.length; ++i) {
                if (!slotDefArray[i].isOverride() || slotDefArray[i].overrides != null) continue;
                this.err("Override of unknown method '" + slotDefArray[i].name + "'", slotDefArray[i].loc);
            }
        }
    }

    private void inheritSlot(Type type, Slot slot) {
        if (!slot.isInherited(type)) {
            return;
        }
        String string = slot.name();
        String string2 = slot.qname();
        Slot slot2 = type.slot(string);
        if (slot2 == null) {
            type.addSlot(slot);
            return;
        }
        if (!(slot2 instanceof SlotDef)) {
            return;
        }
        SlotDef slotDef = (SlotDef)slot2;
        if (!this.doSignaturesMatch(slot, slot2)) {
            if (slot2.isOverride()) {
                this.err("Overridden method '" + string + "' has different signature than '" + string2 + "'", slotDef.loc);
                slotDef.overrides = slotDef;
                return;
            }
            this.err("Slot name '" + string + "' conflicts with inherited slot '" + string2 + "'", slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        if (!slotDef.isOverride()) {
            this.err("Must use 'override' keyword to override '" + string2 + "'", slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        if (slotDef.isAction() && !slot.isAction()) {
            this.err("'" + slotDef.qname + "' cannot be declared an action because it overrides non-action '" + string2 + "'", slotDef.loc);
            return;
        }
        if (slot.isAction() && !slotDef.isAction()) {
            this.err("'" + slotDef.qname + "' must be decalred as an action because it overrides action '" + string2 + "'", slotDef.loc);
            return;
        }
        if (!slot.isVirtual()) {
            this.err("Cannot override non-virtual method '" + string2 + "'", slotDef.loc);
            slotDef.overrides = slotDef;
            return;
        }
        slotDef.overrides = slot;
    }

    private boolean doSignaturesMatch(Slot slot, Slot slot2) {
        Type[] typeArray;
        if (slot.isField()) {
            return false;
        }
        if (slot2.isField()) {
            return false;
        }
        Method method = (Method)slot;
        Method method2 = (Method)slot2;
        if (!((Object)method.returnType()).equals(method2.returnType())) {
            return false;
        }
        Type[] typeArray2 = method.paramTypes();
        if (typeArray2.length != (typeArray = method2.paramTypes()).length) {
            return false;
        }
        for (int i = 0; i < typeArray2.length; ++i) {
            if (((Object)typeArray2[i]).equals(typeArray[i])) continue;
            return false;
        }
        return true;
    }
}

