/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import sedona.Depend;
import sedona.Env;
import sedona.Value;
import sedona.manifest.KitChecksum;
import sedona.manifest.KitManifest;
import sedona.manifest.SlotManifest;
import sedona.manifest.TypeManifest;
import sedona.util.Abstime;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.SlotDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Type;

public class BuildManifest
extends CompilerStep {
    boolean isSys;

    public BuildManifest(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  BuildManifest");
        this.isSys = this.compiler.ast.name.equals("sys");
        this.findReflectiveTypes();
        this.compiler.manifest = this.toKitManifest(this.compiler.ast);
    }

    private void findReflectiveTypes() {
        int n;
        Object object;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (this.isSys) {
            object = this.ns.predefined();
            for (n = 0; n < ((Type[])object).length; ++n) {
                Type type = object[n];
                arrayList.add(type);
                if (type.id() == n) continue;
                throw new IllegalStateException();
            }
        }
        object = new ArrayList();
        n = arrayList.size();
        for (int i = 0; i < this.compiler.ast.types.length; ++i) {
            TypeDef typeDef = this.compiler.ast.types[i];
            if (!typeDef.isaComponent()) continue;
            this.findReflectiveSlots(typeDef);
            if (!typeDef.facets().getb("testonly", false)) {
                typeDef.id = n++;
                arrayList.add(typeDef);
                continue;
            }
            ((ArrayList)object).add(typeDef);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            ((TypeDef)iterator.next()).id = n++;
        }
        arrayList.addAll((Collection<Type>)object);
        this.compiler.ast.reflectiveTypes = arrayList.toArray(new Type[arrayList.size()]);
    }

    private void findReflectiveSlots(TypeDef typeDef) {
        ArrayList<SlotDef> arrayList = new ArrayList<SlotDef>();
        SlotDef[] slotDefArray = typeDef.slotDefs();
        for (int i = 0; i < slotDefArray.length; ++i) {
            SlotDef slotDef = slotDefArray[i];
            if (!slotDef.isReflective()) continue;
            slotDef.declaredId = arrayList.size();
            arrayList.add(slotDef);
        }
        typeDef.reflectiveSlots = arrayList.toArray(new SlotDef[arrayList.size()]);
    }

    private KitManifest toKitManifest(KitDef kitDef) {
        int n;
        KitManifest kitManifest = new KitManifest(kitDef.name);
        kitManifest.vendor = kitDef.vendor;
        kitManifest.version = kitDef.version;
        kitManifest.description = kitDef.description;
        kitManifest.hasNatives = kitDef.natives.length > 0;
        kitManifest.doc = kitDef.doc;
        kitManifest.buildHost = Env.hostname;
        kitManifest.buildTime = Abstime.now();
        kitManifest.depends = new Depend[kitDef.depends.length];
        for (n = 0; n < kitManifest.depends.length; ++n) {
            kitManifest.depends[n] = kitDef.depends[n].depend;
        }
        n = kitDef.reflectiveTypes.length;
        kitManifest.types = new TypeManifest[n];
        for (int i = 0; i < n; ++i) {
            kitManifest.types[i] = this.toTypeManifest(kitManifest, kitDef.reflectiveTypes[i]);
        }
        kitManifest.checksum = new KitChecksum().compute(kitManifest);
        return kitManifest;
    }

    private TypeManifest toTypeManifest(KitManifest kitManifest, Type type) {
        String string = null;
        if (type.base() != null && type.base().isaComponent()) {
            string = type.base().qname();
        }
        TypeManifest typeManifest = new TypeManifest(kitManifest, type.id(), type.name(), type.facets(), string, type.sizeof(), type.flags());
        if (type instanceof TypeDef) {
            SlotDef[] slotDefArray = ((TypeDef)type).reflectiveSlots;
            int n = slotDefArray == null ? 0 : slotDefArray.length;
            typeManifest.slots = new SlotManifest[n];
            for (int i = 0; i < n; ++i) {
                typeManifest.slots[i] = this.toSlotManifest(typeManifest, slotDefArray[i]);
            }
        } else {
            typeManifest.slots = new SlotManifest[0];
        }
        return typeManifest;
    }

    private SlotManifest toSlotManifest(TypeManifest typeManifest, SlotDef slotDef) {
        Type type;
        Value value = null;
        if (slotDef.isField()) {
            FieldDef fieldDef = (FieldDef)slotDef;
            type = fieldDef.type;
            if (fieldDef.init != null) {
                Expr.Literal literal = fieldDef.init.toLiteral();
                if (literal == null) {
                    throw this.err("Invalid slot default literal: " + fieldDef.init, fieldDef.init.loc);
                }
                value = literal.toValue();
            }
        } else {
            MethodDef methodDef = (MethodDef)slotDef;
            type = methodDef.params.length == 0 ? this.ns.voidType : methodDef.params[0].type;
        }
        return new SlotManifest(typeManifest, slotDef.declaredId, slotDef.name, slotDef.facets(), type.qname(), slotDef.rtFlags(), value);
    }
}

