/*
 * Decompiled with CFR 0.152.
 */
package sedonac.jasm;

public class Buffer {
    public byte[] bytes;
    public int count;

    public Buffer() {
        this(1024);
    }

    public Buffer(int n) {
        this.bytes = new byte[n];
    }

    public final int u1(int n) {
        int n2 = this.count;
        if (this.count + 1 >= this.bytes.length) {
            this.grow(this.count + 1);
        }
        this.bytes[this.count++] = (byte)(n & 0xFF);
        return n2;
    }

    public final int u2(int n) {
        int n2 = this.count;
        if (this.count + 2 >= this.bytes.length) {
            this.grow(this.count + 2);
        }
        this.bytes[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(n >>> 0 & 0xFF);
        return n2;
    }

    public final int u4(int n) {
        int n2 = this.count;
        if (this.count + 4 >= this.bytes.length) {
            this.grow(this.count + 4);
        }
        this.bytes[this.count++] = (byte)(n >>> 24 & 0xFF);
        this.bytes[this.count++] = (byte)(n >>> 16 & 0xFF);
        this.bytes[this.count++] = (byte)(n >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(n >>> 0 & 0xFF);
        return n2;
    }

    public final int u8(long l) {
        int n = this.count;
        if (this.count + 8 >= this.bytes.length) {
            this.grow(this.count + 8);
        }
        this.bytes[this.count++] = (byte)(l >>> 56 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 48 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 40 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 32 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 24 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 16 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 8 & 0xFFL);
        this.bytes[this.count++] = (byte)(l >>> 0 & 0xFFL);
        return n;
    }

    public final void utf(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        if (n3 > 65535) {
            throw new RuntimeException("Illegal UTF exception");
        }
        if (this.count + n3 + 2 >= this.bytes.length) {
            this.grow(this.count + n3 + 2);
        }
        this.bytes[this.count++] = (byte)(n3 >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(n3 >>> 0 & 0xFF);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.bytes[this.count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytes[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytes[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytes[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytes[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytes[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void append(Buffer buffer) {
        if (this.count + buffer.count >= this.bytes.length) {
            this.grow(this.count + buffer.count);
        }
        System.arraycopy(buffer.bytes, 0, this.bytes, this.count, buffer.count);
        this.count += buffer.count;
    }

    public void append(byte[] byArray) {
        if (this.count + byArray.length >= this.bytes.length) {
            this.grow(this.count + byArray.length);
        }
        System.arraycopy(byArray, 0, this.bytes, this.count, byArray.length);
        this.count += byArray.length;
    }

    public final void u1(int n, int n2) {
        this.bytes[n + 0] = (byte)(n2 & 0xFF);
    }

    public final void u2(int n, int n2) {
        this.bytes[n + 0] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[n + 1] = (byte)(n2 >>> 0 & 0xFF);
    }

    public final void u4(int n, int n2) {
        this.bytes[n + 0] = (byte)(n2 >>> 24 & 0xFF);
        this.bytes[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        this.bytes[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        this.bytes[n + 3] = (byte)(n2 >>> 0 & 0xFF);
    }

    byte[] trim() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.bytes, 0, byArray, 0, this.count);
        return byArray;
    }

    private void grow(int n) {
        int n2 = Math.max(n, this.bytes.length * 2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        this.bytes = byArray;
    }
}

