/*
 * Decompiled with CFR 0.152.
 */
package sedonac.gen;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedona.Buf;
import sedona.Schema;
import sedona.manifest.TypeManifest;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerSupport;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.gen.ConstPool;
import sedonac.ir.IrAddressable;
import sedonac.ir.IrField;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;
import sedonac.ir.IrPrimitive;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.ir.IrVTable;
import sedonac.namespace.PrimitiveType;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;
import sedonac.scode.SCode;
import sedonac.scode.SCodeImage;

public class ImageGen
extends CompilerSupport {
    Location loc;
    Buf code = new Buf(32768);
    SCodeImage image;
    IrKit[] kits;
    IrType[] types;
    IrMethod[] methods;
    IrMethod[] staticInits;
    IrField[] staticFields;
    ConstPool constPool;
    Backpatch backpatch;
    private int mainBixPos;
    private int testBixPos;
    private int kitsBixPos;

    public ImageGen(Compiler compiler) {
        super(compiler);
        this.image = compiler.image;
        this.kits = compiler.kits;
        this.constPool = new ConstPool(this);
    }

    public void generate() {
        this.code.bigEndian = this.image.endian == 66;
        this.code.checkAlignment = true;
        this.header();
        this.bootstrap();
        this.vtables();
        this.kits();
        this.types();
        this.slots();
        this.logs();
        this.methods();
        this.tests();
        this.constPool.ints();
        this.constPool.floats();
        this.constPool.longs();
        this.constPool.doubles();
        this.constPool.strings();
        this.constPool.bufs();
        this.constPool.arrays();
        this.constPool.qnameTypes();
        this.constPool.qnameSlots();
        this.backpatch();
        this.finish();
    }

    private void header() {
        if (this.image.blockIndexSize == 4) {
            this.headerFor4ByteBix();
        } else {
            this.headerFor2ByteBix();
        }
    }

    private void headerFor2ByteBix() {
        this.code.i4(1590737415);
        this.code.u1(1);
        this.code.u1(5);
        this.code.u1(this.image.blockSize);
        this.code.u1(this.image.refSize);
        this.code.i4(-1);
        this.code.i4(this.compiler.dataSize);
        this.code.u2(-1);
        this.code.u2(-1);
        this.code.u2(-1);
        this.code.u1(this.flat.kits.length);
        this.code.u1(this.scodeFlags());
        this.unhibernateBlockIndex();
        this.blockAlign();
        this.mainBixPos = 16;
        this.testBixPos = 18;
        this.kitsBixPos = 20;
    }

    private void headerFor4ByteBix() {
        this.code.i4(1590737415);
        this.code.u1(2);
        this.code.u1(0);
        this.code.u1(this.image.blockSize);
        this.code.u1(this.image.refSize);
        this.code.i4(-1);
        this.code.i4(this.compiler.dataSize);
        this.code.u4(-1);
        this.code.u4(-1);
        this.code.u4(-1);
        this.code.u1(this.flat.kits.length);
        this.code.u1(this.scodeFlags());
        this.unhibernateBlockIndex();
        this.blockAlign();
        this.mainBixPos = 16;
        this.testBixPos = 20;
        this.kitsBixPos = 24;
    }

    void unhibernateBlockIndex() {
        this.addBlockIndex(this.findMain((String)this.image.unhibernate).codeAddr);
    }

    int scodeFlags() {
        int n = 0;
        if (this.image.debug) {
            n |= 1;
        }
        if (this.image.test) {
            n |= 2;
        }
        return n;
    }

    private void bootstrap() {
        this.writeBlockIndex(this.mainBixPos, this.blockIndex());
        this.code.u1(2);
        this.code.u1(0);
        IrMethod irMethod = this.findMain(this.image.main);
        if (this.image.debug) {
            this.padArg(2);
            this.code.u1(236);
            this.addBlockIndex(this.qnameSlot(irMethod));
        }
        for (int i = 0; i < this.flat.staticInits.length; ++i) {
            this.padArg(2);
            this.code.u1(221);
            this.addBlockIndex(this.flat.staticInits[i].codeAddr);
        }
        this.code.u1(29);
        this.code.u1(30);
        this.padArg(2);
        this.code.u1(221);
        this.addBlockIndex(irMethod.codeAddr);
        this.code.u1(227);
        this.blockAlign();
    }

    private IrMethod findMain(String string) {
        IrMethod[] irMethodArray = this.flat.methods;
        IrMethod irMethod = null;
        for (int i = 0; i < irMethodArray.length; ++i) {
            if (!irMethodArray[i].qname.equals(string)) continue;
            irMethod = irMethodArray[i];
            break;
        }
        if (irMethod == null) {
            throw this.err("Unresolved main method: " + string);
        }
        if (!(irMethod.params.length == 2 && irMethod.params[0].isArray() && irMethod.params[0].arrayOf().isStr() && irMethod.params[1].isInt())) {
            throw this.err("Invalid signature for main, method must be (Str[], int): " + string);
        }
        if (!irMethod.ret.isInt()) {
            throw this.err("Main method must return int: " + string);
        }
        if (!irMethod.isStatic()) {
            throw this.err("Main method must be static: " + string);
        }
        if (irMethod.isNative()) {
            throw this.err("Main method cannot be static: " + string);
        }
        return irMethod;
    }

    private void vtables() {
        for (int i = 0; i < this.flat.virtTypes.length; ++i) {
            this.vtable(this.flat.virtTypes[i].vtable);
        }
    }

    private void vtable(IrVTable irVTable) {
        this.code.align(2);
        irVTable.blockIndex = this.blockIndex();
        for (int i = 0; i < irVTable.methods.length; ++i) {
            IrMethod irMethod = irVTable.methods[i];
            if (irMethod.isAbstract()) {
                if (this.image.blockIndexSize == 4) {
                    this.code.u4(0);
                    continue;
                }
                this.code.u2(0);
                continue;
            }
            this.addBlockIndex(irMethod.codeAddr);
        }
        this.blockAlign();
    }

    private void kits() {
        if (!this.isKitLayoutValid()) {
            throw new IllegalStateException("Mismatch kit field layout");
        }
        if (this.flat.kits.length >= 255) {
            throw this.err("Too many kits");
        }
        Schema.sortKits((Object[])this.flat.kits);
        for (int i = 0; i < this.flat.kits.length; ++i) {
            IrKit irKit = this.flat.kits[i];
            irKit.id = i;
            this.kit(irKit);
            if (i == 0 && !this.flat.kits[0].name.equals("sys")) {
                throw this.err("Sys kit id not 0!");
            }
            if (i < 2 || this.flat.kits[i - 1].name.compareTo(this.flat.kits[i].name) < 0) continue;
            throw this.err("Kits are not sorted by name: " + this.flat.kits[i - 1].name + " >= " + this.flat.kits[i].name);
        }
        this.code.align(2);
        IrField irField = (IrField)this.ns.resolveSlot("sys::Sys.kits");
        irField.storage.setBlockIndex(this.blockIndex());
        this.writeBlockIndex(this.kitsBixPos, this.blockIndex());
        for (int i = 0; i < this.flat.kits.length; ++i) {
            this.addBlockIndex(this.flat.kits[i]);
        }
        this.blockAlign();
    }

    private void kit(IrKit irKit) {
        Object object;
        Object object2;
        int n;
        this.code.align(4);
        irKit.blockIndex = this.blockIndex();
        boolean bl = irKit.name.equals("sys");
        IrType[] irTypeArray = irKit.reflectiveTypes();
        int n2 = irTypeArray.length;
        if (bl) {
            n2 += this.flat.primitives.length;
        }
        if (n2 >= 255) {
            throw this.err("Too many types in kit '" + irKit.name + "'");
        }
        HashMap<String, TypeManifest> hashMap = new HashMap<String, TypeManifest>();
        for (n = 0; n < irKit.manifest.types.length; ++n) {
            object2 = irKit.manifest.types[n];
            hashMap.put(object2.qname, (TypeManifest)object2);
        }
        for (n = 0; n < irTypeArray.length; ++n) {
            object2 = irTypeArray[n];
            object = (TypeManifest)hashMap.get(object2.qname);
            if (object == null) {
                throw this.err("IrType doesn't have manifest entry: " + object2.qname);
            }
            object2.id = object.id;
        }
        Arrays.sort(irTypeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IrType)object).id - ((IrType)object2).id;
            }
        });
        this.code.u1(irKit.id);
        this.code.u1(n2);
        this.code.align(this.image.blockIndexSize);
        this.addBlockIndex(this.string(irKit.name));
        this.addBlockIndex(this.string(irKit.version.toString()));
        this.code.align(4);
        this.code.i4(irKit.manifest.checksum);
        n = 0;
        if (bl) {
            for (int i = 0; i < this.flat.primitives.length; ++i) {
                this.addBlockIndex(this.flat.primitives[i]);
            }
            n = this.flat.primitives.length;
        }
        for (int i = 0; i < irTypeArray.length; ++i) {
            object = irTypeArray[i];
            if (object == null || object.id < 0) {
                throw this.err("Type id not mapped correct: " + i);
            }
            this.addBlockIndex((IrAddressable)object);
        }
        this.blockAlign();
    }

    private boolean isKitLayoutValid() {
        IrType irType = (IrType)this.ns.resolveType("sys::Kit");
        IrField irField = (IrField)irType.slot("id");
        IrField irField2 = (IrField)irType.slot("name");
        IrField irField3 = (IrField)irType.slot("version");
        IrField irField4 = (IrField)irType.slot("checksum");
        IrField irField5 = (IrField)irType.slot("types");
        IrField irField6 = (IrField)irType.slot("typesLen");
        boolean bl = false;
        bl = this.image.blockIndexSize == 4 ? irField.offset == 0 && irField6.offset == 1 && irField2.offset == 4 && irField3.offset == 8 && irField4.offset == 12 && irField5.offset == 16 : irField.offset == 0 && irField6.offset == 1 && irField2.offset == 2 && irField3.offset == 4 && irField4.offset == 8 && irField5.offset == 12;
        return bl;
    }

    private void types() {
        int n;
        if (!this.isTypeLayoutValid()) {
            throw new IllegalStateException("Mismatch type field layout");
        }
        for (n = 0; n < this.flat.primitives.length; ++n) {
            this.type(this.flat.primitives[n]);
        }
        for (n = 0; n < this.flat.reflectiveTypes.length; ++n) {
            this.type(this.flat.reflectiveTypes[n]);
        }
    }

    private void type(IrType irType) {
        this.code.align(2);
        irType.blockIndex = this.blockIndex();
        IrSlot[] irSlotArray = irType.reflectiveSlots;
        if (irSlotArray == null) {
            irSlotArray = new IrSlot[]{};
        }
        if (irSlotArray.length >= 255) {
            throw this.err("Too many slots in type '" + irType.qname + "'");
        }
        if (this.image.blockIndexSize == 4) {
            this.writeTypeFor4ByteBix(irType, irSlotArray);
        } else {
            this.writeTypeFor2ByteBix(irType, irSlotArray);
        }
        this.blockAlign();
    }

    private void writeTypeFor4ByteBix(IrType irType, IrSlot[] irSlotArray) {
        this.code.u1(irType.id);
        this.code.u1(irSlotArray.length);
        this.code.u2(irType.sizeof);
        this.addBlockIndex(this.string(irType.name));
        this.addBlockIndex(irType.kit);
        if (!irType.base.isaComponent()) {
            this.code.u4(0);
        } else {
            this.addBlockIndex((IrType)irType.base);
        }
        this.addBlockIndex(((IrMethod)irType.slot((String)"_iInit")).codeAddr);
        IrType irType2 = (IrType)this.ns.resolveType("sys::Type");
        IrField irField = (IrField)irType2.slot("instanceInitMethod");
        if (irField.type.sizeof() != 4) {
            throw new IllegalStateException("sys::Type.instanceInitMethod must be 4 bytes");
        }
        for (int i = 0; i < irSlotArray.length; ++i) {
            IrSlot irSlot = irType.reflectiveSlots[i];
            if (irSlot.id != i) {
                throw new IllegalStateException("slot id mismatch " + irSlot);
            }
            this.addBlockIndex(irSlotArray[i].reflect);
        }
    }

    private void writeTypeFor2ByteBix(IrType irType, IrSlot[] irSlotArray) {
        this.code.u1(irType.id);
        this.code.u1(irSlotArray.length);
        this.addBlockIndex(this.string(irType.name));
        this.addBlockIndex(irType.kit);
        if (!irType.base.isaComponent()) {
            this.code.u2(0);
        } else {
            this.addBlockIndex((IrType)irType.base);
        }
        this.code.u2(irType.sizeof);
        this.addBlockIndex(((IrMethod)irType.slot((String)"_iInit")).codeAddr);
        IrType irType2 = (IrType)this.ns.resolveType("sys::Type");
        IrField irField = (IrField)irType2.slot("instanceInitMethod");
        if (irField.type.sizeof() != 2) {
            throw new IllegalStateException("sys::Type.instanceInitMethod must be 2 bytes");
        }
        for (int i = 0; i < irSlotArray.length; ++i) {
            IrSlot irSlot = irType.reflectiveSlots[i];
            if (irSlot.id != i) {
                throw new IllegalStateException("slot id mismatch " + irSlot);
            }
            this.addBlockIndex(irSlotArray[i].reflect);
        }
    }

    private void type(IrPrimitive irPrimitive) {
        this.code.align(2);
        irPrimitive.blockIndex = this.blockIndex();
        this.code.u1(irPrimitive.type.id);
        this.code.align(this.image.blockIndexSize);
        this.addBlockIndex(this.string(irPrimitive.type.name));
        this.addBlockIndex((IrKit)this.ns.resolveKit("sys"));
        this.blockAlign();
    }

    private boolean isTypeLayoutValid() {
        IrType irType = (IrType)this.ns.resolveType("sys::Type");
        IrField irField = (IrField)irType.slot("id");
        IrField irField2 = (IrField)irType.slot("name");
        IrField irField3 = (IrField)irType.slot("kit");
        IrField irField4 = (IrField)irType.slot("base");
        IrField irField5 = (IrField)irType.slot("sizeof");
        IrField irField6 = (IrField)irType.slot("instanceInitMethod");
        IrField irField7 = (IrField)irType.slot("slots");
        IrField irField8 = (IrField)irType.slot("slotsLen");
        boolean bl = false;
        bl = this.image.blockIndexSize == 4 ? irField.offset == 0 && irField8.offset == 1 && irField5.offset == 2 && irField2.offset == 4 && irField3.offset == 8 && irField4.offset == 12 && irField6.offset == 16 && irField7.offset == 20 : irField.offset == 0 && irField8.offset == 1 && irField2.offset == 2 && irField3.offset == 4 && irField4.offset == 6 && irField5.offset == 8 && irField6.offset == 10 && irField7.offset == 12;
        return bl;
    }

    private void slots() {
        if (!this.isSlotLayoutValid()) {
            throw new IllegalStateException("Mismatch slot field layout");
        }
        for (int i = 0; i < this.flat.reflectiveSlots.length; ++i) {
            if (this.image.blockIndexSize == 2) {
                this.slotFor2ByteBix(this.flat.reflectiveSlots[i]);
                continue;
            }
            this.slotFor4ByteBix(this.flat.reflectiveSlots[i]);
        }
    }

    private void slotFor2ByteBix(IrSlot irSlot) {
        this.code.align(2);
        irSlot.reflect.setBlockIndex(this.blockIndex());
        this.code.u1(irSlot.id);
        this.code.u1(irSlot.rtFlags);
        this.code.align(this.image.blockIndexSize);
        this.addBlockIndex(this.string(irSlot.name));
        if (irSlot instanceof IrField) {
            IrField irField = (IrField)irSlot;
            this.addTypeBlockIndex(irField.type);
            this.code.u2(irField.offset);
        } else {
            IrMethod irMethod = (IrMethod)irSlot;
            if (irMethod.params.length == 0) {
                this.addTypeBlockIndex(this.ns.voidType);
            } else if (irMethod.params.length == 1) {
                this.addTypeBlockIndex(irMethod.params[0]);
            } else {
                throw this.err("Invalid number of params for action: ", irMethod.qname());
            }
            this.code.u2(irMethod.vindex, false);
        }
        this.blockAlign();
    }

    private void slotFor4ByteBix(IrSlot irSlot) {
        this.code.align(2);
        irSlot.reflect.setBlockIndex(this.blockIndex());
        this.code.u1(irSlot.id);
        this.code.u1(irSlot.rtFlags);
        if (irSlot instanceof IrField) {
            IrField irField = (IrField)irSlot;
            this.code.u2(irField.offset);
            this.addBlockIndex(this.string(irSlot.name));
            this.addTypeBlockIndex(irField.type);
        } else {
            IrMethod irMethod = (IrMethod)irSlot;
            this.code.u2(irMethod.vindex, false);
            this.addBlockIndex(this.string(irSlot.name));
            if (irMethod.params.length == 0) {
                this.addTypeBlockIndex(this.ns.voidType);
            } else if (irMethod.params.length == 1) {
                this.addTypeBlockIndex(irMethod.params[0]);
            } else {
                throw this.err("Invalid number of params for action: ", irMethod.qname());
            }
        }
        this.blockAlign();
    }

    private boolean isSlotLayoutValid() {
        IrType irType = (IrType)this.ns.resolveType("sys::Slot");
        IrField irField = (IrField)irType.slot("id");
        IrField irField2 = (IrField)irType.slot("name");
        IrField irField3 = (IrField)irType.slot("flags");
        IrField irField4 = (IrField)irType.slot("type");
        IrField irField5 = (IrField)irType.slot("handle");
        boolean bl = false;
        bl = this.image.blockIndexSize == 4 ? irField.offset == 0 && irField3.offset == 1 && irField5.offset == 2 && irField2.offset == 4 && irField4.offset == 8 : irField.offset == 0 && irField3.offset == 1 && irField2.offset == 2 && irField4.offset == 4 && irField5.offset == 6;
        return bl;
    }

    private void logs() {
        if (!this.isLogLayoutValid()) {
            throw new IllegalStateException("Mismatch log field layout");
        }
        IrField[] irFieldArray = this.flat.logDefines;
        if (irFieldArray.length >= Short.MAX_VALUE) {
            throw this.err("Too many logs");
        }
        Arrays.sort(irFieldArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IrField)object).qname.compareTo(((IrField)object2).qname);
            }
        });
        int n = 0;
        while (n < irFieldArray.length) {
            IrField irField = irFieldArray[n];
            irField.id = n++;
            this.log(irField);
        }
        this.code.align(2);
        IrField irField = (IrField)this.ns.resolveSlot("sys::Sys.logs");
        irField.storage.setBlockIndex(this.blockIndex());
        for (int i = 0; i < irFieldArray.length; ++i) {
            this.addBlockIndex(irFieldArray[i].storage);
        }
        this.blockAlign();
    }

    private void log(IrField irField) {
        this.code.align(2);
        irField.storage.setBlockIndex(this.blockIndex());
        this.code.u2(irField.id);
        this.code.align(this.image.blockIndexSize);
        this.addBlockIndex(this.string(TypeUtil.toLogName(irField)));
        this.blockAlign();
    }

    private boolean isLogLayoutValid() {
        IrType irType = (IrType)this.ns.resolveType("sys::Log");
        IrField irField = (IrField)irType.slot("id");
        IrField irField2 = (IrField)irType.slot("qname");
        boolean bl = false;
        bl = this.image.blockIndexSize == 4 ? irField.offset == 0 && irField2.offset == 4 : irField.offset == 0 && irField2.offset == 2;
        return bl;
    }

    private void methods() {
        for (int i = 0; i < this.flat.methods.length; ++i) {
            this.method(this.flat.methods[i]);
        }
    }

    private void method(IrMethod irMethod) {
        if (irMethod.isAbstract() || irMethod.isNative()) {
            return;
        }
        int n = irMethod.numParams();
        this.loc = new Location(irMethod.qname);
        irMethod.codeAddr.setBlockIndex(this.blockIndex());
        this.code.u1(n);
        this.code.u1(irMethod.maxLocals);
        if (this.image.debug) {
            this.padArg(2);
            this.code.u1(236);
            this.addBlockIndex(this.qnameSlot(irMethod));
        }
        if (irMethod.code != null) {
            this.ops(irMethod.code);
        }
        this.blockAlign();
        this.loc = new Location("ImageGen");
    }

    private void ops(IrOp[] irOpArray) {
        int n;
        int n2 = this.code.size;
        Backpatch backpatch = this.backpatch;
        while (true) {
            for (n = 0; n < irOpArray.length; ++n) {
                this.op(irOpArray[n]);
            }
            n = 0;
            for (int i = 0; i < irOpArray.length; ++i) {
                if (!irOpArray[i].isJump()) continue;
                n |= this.patchJump(irOpArray, irOpArray[i]);
            }
            if (n == 0) break;
            this.code.size = n2;
            this.backpatch = backpatch;
        }
        for (n = 0; n < irOpArray.length; ++n) {
            if (irOpArray[n].opcode != 235) continue;
            this.patchSwitch(irOpArray, irOpArray[n]);
        }
    }

    private boolean patchJump(IrOp[] irOpArray, IrOp irOp) {
        IrOp irOp2 = this.jumpTarget(irOpArray, irOp.argToInt());
        int n = this.jumpOffset(irOp, irOp2);
        if (irOp.argType() == 15) {
            this.code.s2(irOp.pos + 1, n);
            return false;
        }
        if (n < -128 || n > 127) {
            switch (irOp.opcode) {
                case 142: {
                    irOp.opcode = 146;
                    break;
                }
                case 143: {
                    irOp.opcode = 147;
                    break;
                }
                case 144: {
                    irOp.opcode = 148;
                    break;
                }
                case 145: {
                    irOp.opcode = 149;
                    break;
                }
                case 150: {
                    irOp.opcode = 156;
                    break;
                }
                case 151: {
                    irOp.opcode = 157;
                    break;
                }
                case 152: {
                    irOp.opcode = 158;
                    break;
                }
                case 153: {
                    irOp.opcode = 159;
                    break;
                }
                case 154: {
                    irOp.opcode = 160;
                    break;
                }
                case 155: {
                    irOp.opcode = 161;
                    break;
                }
                default: {
                    throw new IllegalStateException("missing jmp to jmpfar " + irOp);
                }
            }
            return true;
        }
        this.code.s1(irOp.pos + 1, n);
        return false;
    }

    private void patchSwitch(IrOp[] irOpArray, IrOp irOp) {
        String[] stringArray = TextUtil.split((String)irOp.arg, (char)',');
        for (int i = 0; i < stringArray.length; ++i) {
            IrOp irOp2 = this.jumpTarget(irOpArray, Integer.parseInt(stringArray[i]));
            int n = this.jumpOffset(irOp, irOp2);
            this.code.s2(irOp.pos + 3 + i * 2, n);
        }
    }

    private IrOp jumpTarget(IrOp[] irOpArray, int n) {
        if (n < 0 || n >= irOpArray.length) {
            throw this.err("Invalid jump index " + n);
        }
        return irOpArray[n];
    }

    private int jumpOffset(IrOp irOp, IrOp irOp2) {
        int n = irOp2.pos - irOp.pos;
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw this.err("Jump too far");
        }
        return n;
    }

    private void op(IrOp irOp) {
        this.padArg(this.argAlignment(irOp));
        irOp.pos = this.code.size;
        if (irOp.isFieldOp()) {
            this.fieldOp(irOp);
        } else if (irOp.opcode == 222) {
            this.callVirtual(irOp);
        } else if (irOp.opcode == 223 || irOp.opcode == 224 || irOp.opcode == 225) {
            this.callNative(irOp);
        } else if (irOp.opcode == 235) {
            this.switchOp(irOp);
        } else if (irOp.opcode == 238) {
            this.code.u1(25);
            this.opArg(irOp);
        } else {
            this.code.u1(irOp.opcode);
            this.opArg(irOp);
        }
    }

    private void opArg(IrOp irOp) {
        switch (irOp.argType()) {
            case 0: {
                return;
            }
            case 1: {
                this.code.u1(irOp.argToInt());
                return;
            }
            case 2: {
                this.code.u2(irOp.argToInt());
                return;
            }
            case 3: {
                this.code.i4(irOp.argToInt());
                return;
            }
            case 4: {
                this.addBlockIndex(this.toInt(irOp.argToInt()));
                return;
            }
            case 5: {
                this.addBlockIndex(this.toLong(irOp.argToLong()));
                return;
            }
            case 6: {
                this.addBlockIndex(this.toFloat(irOp.argToFloat()));
                return;
            }
            case 7: {
                this.addBlockIndex(this.toDouble(irOp.argToDouble()));
                return;
            }
            case 8: {
                this.addBlockIndex(this.string(irOp.argToStr()));
                return;
            }
            case 9: {
                this.addBlockIndex(this.buf(irOp.argToBuf()));
                return;
            }
            case 17: {
                this.addBlockIndex(this.array((Expr.Literal)irOp.resolvedArg));
                return;
            }
            case 13: {
                this.addBlockIndex(irOp.argToMethod().codeAddr);
                return;
            }
            case 14: {
                this.code.s1(255);
                return;
            }
            case 15: {
                this.code.s2(65535);
                return;
            }
            case 11: {
                this.addBlockIndex(irOp.argToIrSlot().reflect);
                break;
            }
            case 10: {
                if (irOp.opcode == 231) {
                    this.addBlockIndex(irOp.argToIrType().vtable);
                } else {
                    this.addTypeBlockIndex(irOp.argToType());
                }
                return;
            }
            default: {
                throw new IllegalStateException(SCode.name(irOp.opcode));
            }
        }
    }

    private int argAlignment(IrOp irOp) {
        if (this.image.blockIndexSize == 4) {
            switch (irOp.argType()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 4;
                }
                case 7: {
                    return 4;
                }
                case 8: {
                    return 4;
                }
                case 9: {
                    return 4;
                }
                case 12: {
                    return irOp.argToField().offsetWidth(this.image.blockIndexSize);
                }
                case 13: {
                    return 0;
                }
                case 11: {
                    return 4;
                }
                case 10: {
                    return 4;
                }
                case 14: {
                    return 0;
                }
                case 15: {
                    return 2;
                }
                case 16: {
                    return 2;
                }
                case 17: {
                    return 4;
                }
            }
            throw new IllegalStateException(SCode.name(irOp.opcode));
        }
        switch (irOp.argType()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 2;
            }
            case 12: {
                return irOp.argToField().offsetWidth(this.image.blockIndexSize);
            }
            case 13: {
                return 0;
            }
            case 11: {
                return 2;
            }
            case 10: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 2;
            }
            case 16: {
                return 2;
            }
            case 17: {
                return 2;
            }
        }
        throw new IllegalStateException(SCode.name(irOp.opcode));
    }

    private void padArg(int n) {
        if (n < 2) {
            return;
        }
        int n2 = this.code.size + 1;
        int n3 = n2 % n;
        if (n3 == 0) {
            return;
        }
        this.code.pad(n - n3);
        if ((this.code.size + 1) % n != 0) {
            throw new IllegalStateException();
        }
    }

    private void callVirtual(IrOp irOp) {
        IrMethod irMethod = irOp.argToMethod();
        if (irMethod.vindex < 0) {
            throw new IllegalStateException("Method not assigned vindex: " + irMethod.qname);
        }
        this.code.u1(irOp.opcode);
        this.code.u2(irMethod.vindex, false);
        this.code.u1(irMethod.numParams());
    }

    private void callNative(IrOp irOp) {
        IrMethod irMethod = irOp.argToMethod();
        if (irMethod.nativeId == null) {
            throw new IllegalStateException("Method not assigned native id: " + irMethod.qname);
        }
        int n = irMethod.numParams();
        this.code.u1(irOp.opcode);
        this.code.u1(irMethod.nativeId.kitId);
        this.code.u1(irMethod.nativeId.methodId);
        this.code.u1(n);
    }

    private void fieldOp(IrOp irOp) {
        IrField irField = irOp.argToField();
        int n = irField.offsetWidth(this.image.blockIndexSize);
        int n2 = irField.offset;
        if (irOp.opcode == 210) {
            this.code.u1(irOp.opcode);
            this.addBlockIndex(irField.storage);
            return;
        }
        if (n2 < 0) {
            throw this.err("Field offset not set: " + irField.qname);
        }
        if (n2 > Integer.MAX_VALUE) {
            throw this.err("Field offset is too big: " + irField.qname);
        }
        switch (irOp.opcode) {
            case 163: 
            case 167: 
            case 172: 
            case 176: 
            case 181: 
            case 185: 
            case 190: 
            case 194: 
            case 199: 
            case 203: 
            case 208: 
            case 212: 
            case 215: 
            case 218: {
                break;
            }
            default: {
                throw this.err("Invalid field opcode used for IR", irField.qname + " " + SCode.name(irOp.opcode));
            }
        }
        if (n == 1) {
            this.code.u1(irOp.opcode);
            this.code.u1(n2);
        } else if (n == 2) {
            this.code.u1(irOp.opcode + 1);
            if (this.code.size % 2 != 0) {
                throw new IllegalStateException();
            }
            this.code.u2(n2);
        } else {
            if (irOp.opcode == 208) {
                throw new IllegalStateException("Const field too wide: " + irField.qname);
            }
            this.code.u1(irOp.opcode + 2);
            if (this.code.size % 4 != 0) {
                throw new IllegalStateException();
            }
            this.code.i4(n2);
        }
    }

    private void switchOp(IrOp irOp) {
        int n = TextUtil.split((String)irOp.arg, (char)',').length;
        this.code.u1(irOp.opcode);
        this.code.u2(n);
        for (int i = 0; i < n; ++i) {
            this.code.s2(65535);
        }
    }

    private ConstPool.IrInt toInt(int n) {
        return this.constPool.toInt(new Integer(n));
    }

    private ConstPool.IrLong toLong(long l) {
        return this.constPool.toLong(new Long(l));
    }

    private ConstPool.IrFloat toFloat(float f) {
        return this.constPool.toFloat(new Float(f));
    }

    private ConstPool.IrDouble toDouble(double d) {
        return this.constPool.toDouble(new Double(d));
    }

    private ConstPool.IrStr string(String string) {
        return this.constPool.string(string);
    }

    private ConstPool.IrBuf buf(Buf buf) {
        return this.constPool.buf(buf);
    }

    private ConstPool.IrArray array(Expr.Literal literal) {
        return this.constPool.array(literal);
    }

    private ConstPool.IrQnameType qnameType(Type type) {
        return this.constPool.qnameType(type);
    }

    private ConstPool.IrQnameSlot qnameSlot(Slot slot) {
        return this.constPool.qnameSlot(slot);
    }

    private void tests() {
        this.code.align(2);
        if (!this.image.test) {
            this.writeBlockIndex(this.testBixPos, 0);
            return;
        }
        this.writeBlockIndex(this.testBixPos, this.blockIndex());
        IrMethod[] irMethodArray = this.compiler.testMethods;
        this.code.u2(irMethodArray.length);
        this.code.align(this.image.blockIndexSize);
        for (int i = 0; i < irMethodArray.length; ++i) {
            IrMethod irMethod = irMethodArray[i];
            this.addBlockIndex(this.qnameSlot(irMethod));
            this.addBlockIndex(irMethod.codeAddr);
        }
        this.blockAlign();
    }

    private void backpatch() {
        Backpatch backpatch = this.backpatch;
        while (backpatch != null) {
            int n = backpatch.ir.getBlockIndex();
            if (n == 0) {
                throw this.err("Attempt to back patch IR with no block index: " + backpatch.ir);
            }
            if (this.image.blockIndexSize == 2 && n > 65535) {
                throw this.err("Block index is too overflow for IR: " + backpatch.ir);
            }
            this.writeBlockIndex(backpatch.off, n, backpatch.ir.alignBlockIndex());
            backpatch = backpatch.next;
        }
    }

    private void finish() {
        this.code.i4(8, this.code.size);
        this.image.code = this.code.trim();
    }

    public int blockIndex() {
        int n = this.code.size;
        if (n % this.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        return n / this.image.blockSize;
    }

    public void blockAlign() {
        this.code.align(this.image.blockSize);
    }

    @Override
    public CompilerException err(String string) {
        return this.err(string, this.loc);
    }

    public void writeBlockIndex(int n, int n2) {
        if (this.image.blockIndexSize == 4) {
            this.code.u4(n, n2);
        } else {
            this.code.u2(n, n2);
        }
    }

    public void writeBlockIndex(int n, int n2, boolean bl) {
        if (this.image.blockIndexSize == 4) {
            this.code.u4(n, n2, bl);
        } else {
            this.code.u2(n, n2, bl);
        }
    }

    private void addBlockIndex(IrAddressable irAddressable) {
        Backpatch backpatch = new Backpatch();
        backpatch.off = this.code.size;
        backpatch.ir = irAddressable;
        backpatch.next = this.backpatch;
        this.backpatch = backpatch;
        if (this.image.blockIndexSize == 4) {
            this.code.u4(-1, irAddressable.alignBlockIndex());
        } else {
            this.code.u2(65535, irAddressable.alignBlockIndex());
        }
    }

    public void addTypeBlockIndex(Type type) {
        if (type instanceof IrType) {
            this.addBlockIndex((IrType)type);
        } else {
            this.addBlockIndex(this.flat.primitives[((PrimitiveType)type).id]);
        }
    }

    static class Backpatch {
        int off;
        IrAddressable ir;
        Backpatch next;

        Backpatch() {
        }
    }
}

