/*
 * Decompiled with CFR 0.152.
 */
package sedona.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sedona.web.WebMsg;
import sedona.web.WebUtil;

public class WebReq
extends WebMsg {
    public String version = "1.0";
    public String method = "GET";
    public String uri = "/";
    public byte[] body = null;

    public void readText(InputStream inputStream) throws IOException {
        String string = WebReq.readLine(inputStream);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            this.method = stringTokenizer.nextToken();
            this.uri = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            this.version = string2.substring(5);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException("Invalid HTTP Request:" + string);
        }
        this.readHeadersText(inputStream);
        int n = inputStream.available();
        if (n > 0) {
            this.body = new byte[n];
            inputStream.read(this.body);
        }
    }

    public void writeText(OutputStream outputStream) throws IOException {
        WebReq.writeLine(outputStream, this.method + " " + this.uri + " HTTP/" + this.version);
        this.writeHeadersText(outputStream);
        if (this.body != null) {
            outputStream.write(this.body);
        }
        outputStream.flush();
    }

    public void readBinary(InputStream inputStream) throws IOException {
        WebUtil.readU2(inputStream);
        this.method = WebUtil.decompressMethod(inputStream.read());
        this.uri = WebUtil.readStr(inputStream);
        this.readHeadersBinary(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read();
        while (n >= 0) {
            byteArrayOutputStream.write(n);
            n = inputStream.read();
        }
        this.body = byteArrayOutputStream.toByteArray();
    }

    public void writeBinary(OutputStream outputStream) throws IOException {
        WebUtil.writeU2(26678, outputStream);
        outputStream.write(WebUtil.compressMethod(this.method));
        WebUtil.writeStr(this.uri, outputStream);
        this.writeHeadersBinary(outputStream);
        if (this.body != null) {
            outputStream.write(this.body, 0, this.body.length);
        }
        outputStream.flush();
    }
}

