/*
 * Decompiled with CFR 0.152.
 */
package sedona.util.sedonadev;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import sedona.util.FileUtil;
import sedona.xml.XParser;

public final class Upload {
    protected final String baseUri;
    protected final String vendor;
    protected final String password;
    protected final File file;
    private String ext;
    private String fileType;

    public static void main(String[] stringArray) {
        try {
            File file;
            String string = "http://sedonadev.org/download/upload";
            String string2 = null;
            String string3 = null;
            int n = 0;
            if (stringArray.length < 1) {
                Upload.printHelp();
                System.exit(-1);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.charAt(0) != '-') continue;
                if (string4.equals("-?") || string4.equals("-help")) {
                    Upload.printHelp();
                    System.exit(-1);
                    continue;
                }
                if (string4.equals("-u")) {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                        Upload.err("ERROR: Missing uri argument");
                    }
                    string = stringArray[++i];
                    n += 2;
                    continue;
                }
                if (string4.equals("-v")) {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                        Upload.err("ERROR: Missing vendor name argument");
                    }
                    string2 = stringArray[++i];
                    n += 2;
                    continue;
                }
                if (string4.equals("-p")) {
                    if (i + 1 >= stringArray.length || stringArray[i + 1].charAt(0) == '-') {
                        Upload.err("ERROR: Missing password argument");
                    }
                    string3 = stringArray[++i];
                    n += 2;
                    continue;
                }
                System.out.println("WARNING: Unknown option " + string4);
                ++n;
            }
            if (n >= stringArray.length) {
                Upload.err("ERRROR: Missing file argument");
            }
            if (!(file = new File(stringArray[n])).exists()) {
                Upload.err("ERROR: File not found: " + file);
            }
            new Upload(string, string2, string3, file).upload();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public Upload(String string, String string2, String string3, File file) {
        this.baseUri = string;
        this.vendor = string2;
        this.password = string3;
        this.file = file;
    }

    public void upload() throws Exception {
        this.parseFile();
        this.transfer();
    }

    private void parseFile() throws Exception {
        if (this.file.getName().endsWith(".zip")) {
            this.ext = ".zip";
            this.fileType = "build";
        } else if (this.file.getName().endsWith(".par")) {
            this.ext = ".zip";
            this.fileType = "platform";
        } else if (this.file.getName().endsWith(".xml")) {
            this.ext = ".xml";
            String string = XParser.make(this.file).parse().name();
            if (string.equals("kitManifest") || string.equals("sedonaPlatform")) {
                this.fileType = string;
            }
        }
        if (this.fileType == null) {
            Upload.err("ERROR: Unknown file type: " + this.file.getCanonicalPath());
        }
    }

    protected void transfer() throws Exception {
        System.out.println("Upload " + this.fileType + " [" + this.file.getCanonicalPath() + "]");
        String string = Upload.makeDigest(this.vendor, this.password);
        URL uRL = new URL(this.baseUri + "?type=" + this.fileType + ";vendor=" + this.vendor + ";digest=" + string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        if (this.ext.equals(".zip")) {
            httpURLConnection.setRequestProperty("Content-Type", "application/zip");
        } else if (this.ext.equals(".xml")) {
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        } else {
            throw new IllegalStateException("Ext = " + this.ext);
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
        FileUtil.pipe(bufferedInputStream, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).flush();
        ((InputStream)bufferedInputStream).close();
        byte[] byArray = new byte[httpURLConnection.getContentLength()];
        DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
        dataInputStream.readFully(byArray);
        String string2 = new String(byArray);
        if (!string2.equals("Got it!")) {
            System.out.println("--- resp ---");
            System.out.println(string2);
            System.out.println("------------");
            throw new Exception("Unexpected response");
        }
        System.out.println("*** Success! ***");
        System.out.println("");
    }

    public static String makeDigest(String string, String string2) throws Exception {
        String string3 = string.toLowerCase() + ":" + string2;
        byte[] byArray = string3.getBytes("UTF-8");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray2.length; ++i) {
            String string4 = Integer.toHexString(byArray2[i] & 0xFF);
            if (string4.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    static void printHelp() {
        System.out.println("usage:");
        System.out.println("  upload [options] <file>");
        System.out.println("options:");
        System.out.println("  -u <uri>       The uri to upload to.");
        System.out.println("                 If omitted, http://sedonadev.org/download/upload is used.");
        System.out.println("  -v <vendor>    The vendor name used to authenticate");
        System.out.println("  -p <password>  The password used to authenticate");
        System.out.println("  -? -help       Print this usage synopsis");
        System.out.println("");
    }

    static void err(String string) {
        System.out.println(string);
        System.out.println("");
        System.exit(-1);
    }
}

