/*
 * Decompiled with CFR 0.152.
 */
package sedona.util.sedonadev;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipInputStream;
import sedona.Env;
import sedona.KitPart;
import sedona.manifest.KitManifest;
import sedona.util.Log;
import sedona.util.TextUtil;
import sedona.xml.XParser;

public final class Download {
    private static Log log = new Log("sedonadev.org");
    private static String[] sites;

    private Download() {
    }

    public static KitManifest fetchManifest(KitPart kitPart) throws Exception {
        String string = "/download/kit/" + kitPart.key + ".xml";
        URLConnection uRLConnection = Download.open(string);
        if (uRLConnection == null) {
            return null;
        }
        log.info("Downloading " + uRLConnection.getURL());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        KitManifest kitManifest = KitManifest.fromXml(XParser.make(kitPart.key + ".xml", bufferedInputStream).parse());
        return kitManifest;
    }

    public static ZipInputStream fetchPar(String string) throws Exception {
        String string2 = "/download/platform/" + string + ".par";
        URLConnection uRLConnection = Download.open(string2);
        if (uRLConnection == null) {
            return null;
        }
        log.info("Downloading " + uRLConnection.getURL());
        return new ZipInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
    }

    public static String fetchString(String string) throws Exception {
        int n;
        URLConnection uRLConnection = Download.open(string);
        if (uRLConnection == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    private static URLConnection open(String string) {
        for (int i = 0; i < sites.length; ++i) {
            HttpURLConnection httpURLConnection = null;
            try {
                httpURLConnection = (HttpURLConnection)new URL(sites[i] + string).openConnection();
                if (httpURLConnection.getResponseCode() == 200) {
                    return httpURLConnection;
                }
                httpURLConnection.disconnect();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        String string = Env.getProperty("sedonadev.org", "http://sedonadev.org");
        sites = TextUtil.splitAndTrim(string, ',');
    }
}

