/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import sedona.Buf;
import sedona.Component;
import sedona.Env;
import sedona.Kit;
import sedona.KitPart;
import sedona.Link;
import sedona.Schema;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.sox.FileTransfer;
import sedona.sox.KitVersion;
import sedona.sox.Msg;
import sedona.sox.SoxComponent;
import sedona.sox.SoxException;
import sedona.sox.SoxExchange;
import sedona.sox.SoxFile;
import sedona.sox.SoxReceiver;
import sedona.sox.SoxUtil;
import sedona.sox.VersionInfo;
import sedona.util.Version;

public class SoxClient {
    public boolean traceMsg = false;
    public final DaspSocket socket;
    public final InetAddress addr;
    public final int port;
    public final String username;
    public Listener listener;
    final String password;
    DaspSession session;
    String closeCause = "never opened";
    boolean allTreeEvents;
    SoxComponent[] cache = new SoxComponent[1024];
    SoxExchange exchange;
    SoxReceiver receiver;
    Object sendLock = new Object();
    FileTransfer fileTransfer;
    volatile boolean closing;
    private SoxUtil util;
    private final Object subscribeSyncLock = new Object();

    public SoxClient(DaspSocket daspSocket, InetAddress inetAddress, int n, String string, String string2) {
        this.socket = daspSocket;
        this.addr = inetAddress;
        this.port = n;
        this.username = string;
        this.password = string2;
        this.util = new SoxUtil(this);
        this.initOptions();
    }

    public synchronized void connect() throws Exception {
        this.connect(null);
    }

    public synchronized void connect(Hashtable hashtable) throws Exception {
        if (!this.isClosed()) {
            throw new SoxException("Already open!");
        }
        this.session = this.socket.connect(this.addr, this.port, this.username, this.password, hashtable);
        this.session.listener = new DaspSession.Listener(){

            @Override
            public void daspSessionClosed(DaspSession daspSession) {
                SoxClient.this.closeCause = daspSession.closeCause();
                if (!SoxClient.this.closing) {
                    SoxClient.this.close();
                }
            }
        };
        this.closeCause = "???";
        this.exchange = new SoxExchange(this);
        this.receiver = new SoxReceiver(this);
        this.receiver.start();
    }

    public DaspSession session() {
        return this.session;
    }

    public int localId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.id;
    }

    public int remoteId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.remoteId();
    }

    public boolean isClosed() {
        DaspSession daspSession = this.session;
        if (daspSession == null) {
            return true;
        }
        if (daspSession.isClosed()) {
            this.closeCause = daspSession.closeCause();
            return true;
        }
        return false;
    }

    public void close() {
        Object object;
        if (this.closing) {
            return;
        }
        this.closing = true;
        try {
            object = this.receiver;
            if (object != null) {
                ((SoxReceiver)object).kill();
            }
            this.receiver = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object = this.session;
            if (object != null) {
                ((DaspSession)object).close();
            }
            this.session = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.exchange = null;
        this.session = null;
        this.receiver = null;
        this.cache = new SoxComponent[1024];
        this.allTreeEvents = false;
        this.util = null;
        try {
            if (this.listener != null) {
                this.listener.soxClientClosed(this);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.closing = false;
    }

    public synchronized Schema readSchema() throws Exception {
        if (this.util.schema != null) {
            return this.util.schema;
        }
        Msg msg = Msg.prepareRequest(118);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(86);
        int n = msg2.u1();
        KitPart[] kitPartArray = new KitPart[n];
        for (int i = 0; i < n; ++i) {
            kitPartArray[i] = new KitPart(msg2.str(), msg2.i4());
        }
        this.util.schema = Schema.load(kitPartArray);
        return this.util.schema;
    }

    public synchronized VersionInfo readVersion() throws Exception {
        int n;
        if (this.util.version != null) {
            return this.util.version;
        }
        Schema schema = this.readSchema();
        Msg msg = Msg.prepareRequest(121);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(89);
        String string = msg2.str();
        int n2 = msg2.u1();
        KitVersion[] kitVersionArray = new KitVersion[schema.kits.length];
        for (n = 0; n < kitVersionArray.length; ++n) {
            Kit kit = schema.kits[n];
            Version version = new Version(msg2.str());
            kitVersionArray[n] = new KitVersion(kit.name, kit.checksum, version);
        }
        this.util.version = new VersionInfo(string, n2, kitVersionArray);
        n = msg2.u1();
        for (int i = 0; i < n; ++i) {
            this.util.version.props.put(msg2.str(), msg2.str());
        }
        return this.util.version;
    }

    public synchronized Value readProp(SoxComponent soxComponent, Slot slot) throws Exception {
        this.checkMine(soxComponent);
        return this.readProp(soxComponent.id(), slot);
    }

    public synchronized Value readProp(int n, Slot slot) throws Exception {
        Msg msg = Msg.prepareRequest(114);
        msg.u2(n);
        msg.u1(slot.id);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(82);
        msg2.u2();
        msg2.u1();
        int n2 = msg2.u1();
        Value value = slot.isAsStr() ? Str.make("") : Value.defaultForType(n2);
        return value.decodeBinary(msg2);
    }

    public synchronized SoxComponent loadApp() throws Exception {
        return this.load(0);
    }

    public synchronized SoxComponent load(int n) throws Exception {
        if (n < 0) {
            return null;
        }
        if (this.cache(n) != null) {
            return this.cache(n);
        }
        return this.load(new int[]{n})[0];
    }

    public synchronized SoxComponent[] load(int[] nArray) throws Exception {
        return this.load(nArray, true);
    }

    public synchronized SoxComponent[] load(int[] nArray, boolean bl) throws Exception {
        int n;
        this.readSchema();
        int n2 = nArray.length;
        SoxComponent[] soxComponentArray = new SoxComponent[n2];
        ArrayList<Msg> arrayList = new ArrayList<Msg>();
        for (int i = 0; i < n2; ++i) {
            n = nArray[i];
            soxComponentArray[i] = this.cache(n);
            if (soxComponentArray[i] != null) continue;
            arrayList.add(Msg.makeUpdateReq(n, 116));
        }
        if (arrayList.size() == 0) {
            return soxComponentArray;
        }
        Msg[] msgArray = this.requests(arrayList.toArray(new Msg[arrayList.size()]));
        for (n = 0; n < msgArray.length; ++n) {
            Msg msg = msgArray[n];
            if (!bl && msg.isError()) continue;
            msg.checkResponse(67);
            this.applyToCache(msg);
        }
        for (n = 0; n < n2; ++n) {
            int n3 = nArray[n];
            soxComponentArray[n] = this.cache(n3);
            if (!bl || soxComponentArray[n] != null) continue;
            throw new IllegalStateException("" + n3);
        }
        return soxComponentArray;
    }

    public synchronized SoxComponent update(SoxComponent soxComponent, int n) throws Exception {
        this.update(new SoxComponent[]{soxComponent}, n);
        return soxComponent;
    }

    public synchronized void update(SoxComponent[] soxComponentArray, int n) throws Exception {
        int n2;
        this.checkMine(soxComponentArray);
        ArrayList<Msg> arrayList = new ArrayList<Msg>();
        for (int i = 0; i < soxComponentArray.length; ++i) {
            n2 = soxComponentArray[i].id;
            if ((n & 1) != 0) {
                arrayList.add(Msg.makeUpdateReq(n2, 116));
            }
            if ((n & 2) != 0) {
                arrayList.add(Msg.makeUpdateReq(n2, 99));
            }
            if ((n & 4) != 0) {
                arrayList.add(Msg.makeUpdateReq(n2, 114));
            }
            if ((n & 8) == 0) continue;
            arrayList.add(Msg.makeUpdateReq(n2, 108));
        }
        if (arrayList.size() == 0) {
            return;
        }
        Msg[] msgArray = this.requests(arrayList.toArray(new Msg[arrayList.size()]));
        for (n2 = 0; n2 < msgArray.length; ++n2) {
            Msg msg = msgArray[n2];
            msg.checkResponse(67);
            this.applyToCache(msg);
        }
    }

    public synchronized void subscribeToAllTreeEvents() throws Exception {
        if (this.getSoxVersion() == null) {
            this.request(Msg.makeSubscribeReq(0, 97));
        } else {
            this.request(Msg.makeSubscribeReq(0, 255));
        }
        this.allTreeEvents = true;
        for (int i = 0; i < this.cache.length; ++i) {
            if (this.cache[i] == null) continue;
            this.cache[i].subscription |= 1;
        }
    }

    public synchronized void subscribe(SoxComponent soxComponent, int n) throws Exception {
        this.subscribe(new SoxComponent[]{soxComponent}, n);
    }

    public synchronized void subscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        if (this.getSoxVersion() != null) {
            this.batchSubscribe(soxComponentArray, n, 5000L);
        } else {
            this.doSubscribe(soxComponentArray, n);
        }
    }

    public synchronized void subscribeAsync(SoxComponent[] soxComponentArray, int n) throws Exception {
        if (this.getSoxVersion() != null) {
            this.batchSubscribe(soxComponentArray, n, -1L);
        } else {
            this.doSubscribe(soxComponentArray, n);
        }
    }

    private Version getSoxVersion() {
        try {
            VersionInfo versionInfo = this.readVersion();
            return Version.parse(versionInfo.props.getProperty("soxVer"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchSubscribe(SoxComponent[] soxComponentArray, int n, long l) throws Exception {
        Object object;
        if (soxComponentArray.length > 255) {
            throw new SoxException("Cannot subscribe to more than 255 components: '" + soxComponentArray.length + "'");
        }
        this.checkMine(soxComponentArray);
        ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
        for (int i = 0; i < soxComponentArray.length; ++i) {
            object = soxComponentArray[i];
            if ((soxComponentArray[i].subscription() & n) == n) continue;
            arrayList.add(soxComponentArray[i]);
        }
        if (arrayList.size() == 0) {
            return;
        }
        SoxComponent[] soxComponentArray2 = arrayList.toArray(new SoxComponent[arrayList.size()]);
        object = Msg.prepareRequest(115);
        ((Buf)object).u1(n);
        ((Buf)object).u1(soxComponentArray2.length);
        for (int i = 0; i < soxComponentArray2.length; ++i) {
            ((Buf)object).u2(soxComponentArray2[i].id);
        }
        Msg msg = this.request((Msg)object);
        msg.checkResponse(83);
        if (l < 0L) {
            return;
        }
        Object object2 = this.subscribeSyncLock;
        synchronized (object2) {
            boolean[] blArray = new boolean[soxComponentArray2.length];
            long l2 = Env.ticks();
            int n2 = msg.u1();
            while (n2 > 0 && l2 + l > Env.ticks()) {
                this.subscribeSyncLock.wait(250L);
                for (int i = 0; i < soxComponentArray2.length; ++i) {
                    SoxComponent soxComponent;
                    if (blArray[i] || (soxComponent = this.cache(soxComponentArray2[i].id)) == null || !(blArray[i] = (soxComponent.subscription() & n) == n)) continue;
                    --n2;
                    l2 = System.currentTimeMillis();
                }
            }
        }
    }

    private void doSubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        int n2;
        this.checkMine(soxComponentArray);
        ArrayList<Msg> arrayList = new ArrayList<Msg>();
        for (int i = 0; i < soxComponentArray.length; ++i) {
            SoxComponent soxComponent = soxComponentArray[i];
            int n3 = soxComponent.id;
            int n4 = soxComponent.subscription();
            int n5 = n & ~n4;
            if ((n5 & 1) != 0) {
                arrayList.add(Msg.makeSubscribeReq(n3, 116));
            }
            if ((n5 & 2) != 0) {
                arrayList.add(Msg.makeSubscribeReq(n3, 99));
            }
            if ((n5 & 4) != 0) {
                arrayList.add(Msg.makeSubscribeReq(n3, 114));
            }
            if ((n5 & 8) == 0) continue;
            arrayList.add(Msg.makeSubscribeReq(n3, 108));
        }
        if (arrayList.size() == 0) {
            return;
        }
        Msg[] msgArray = this.requests(arrayList.toArray(new Msg[arrayList.size()]));
        for (n2 = 0; n2 < msgArray.length; ++n2) {
            Msg msg = msgArray[n2];
            msg.checkResponse(83);
            this.applyToCache(msg);
        }
        for (n2 = 0; n2 < soxComponentArray.length; ++n2) {
            soxComponentArray[n2].subscription |= n;
        }
    }

    public synchronized void unsubscribeToAllTreeEvents() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.request(Msg.makeUnsubscribeReq(0, 255));
        this.allTreeEvents = false;
        for (int i = 0; i < this.cache.length; ++i) {
            if (this.cache[i] == null) continue;
            this.cache[i].subscription &= 0xFFFFFFFE;
        }
    }

    public synchronized void unsubscribe(SoxComponent soxComponent, int n) throws Exception {
        this.unsubscribe(new SoxComponent[]{soxComponent}, n);
    }

    public synchronized void unsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        this.checkMine(soxComponentArray);
        if (this.isClosed()) {
            return;
        }
        if (this.allTreeEvents) {
            n &= 0xFFFFFFFE;
        }
        ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
        for (int i = 0; i < soxComponentArray.length; ++i) {
            if ((soxComponentArray[i].subscription & n) == 0) continue;
            arrayList.add(soxComponentArray[i]);
        }
        if (arrayList.size() == 0) {
            return;
        }
        SoxComponent[] soxComponentArray2 = arrayList.toArray(new SoxComponent[arrayList.size()]);
        if (this.getSoxVersion() != null) {
            this.batchUnsubscribe(soxComponentArray2, n);
        } else {
            this.doUnsubscribe(soxComponentArray2, n);
        }
        for (int i = 0; i < soxComponentArray.length; ++i) {
            soxComponentArray[i].subscription &= ~n;
        }
    }

    private void batchUnsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        Msg msg = Msg.prepareRequest(117);
        msg.u1(n);
        msg.u1(soxComponentArray.length);
        for (int i = 0; i < soxComponentArray.length; ++i) {
            msg.u2(soxComponentArray[i].id);
        }
        this.request(msg);
    }

    private void doUnsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        Msg[] msgArray = new Msg[soxComponentArray.length];
        for (int i = 0; i < soxComponentArray.length; ++i) {
            msgArray[i] = Msg.makeUnsubscribeReq(soxComponentArray[i].id, n);
        }
        this.requests(msgArray);
    }

    public synchronized void invoke(SoxComponent soxComponent, Slot slot, Value value) throws Exception {
        this.checkMine(soxComponent);
        this.invoke(soxComponent.id, slot, value);
    }

    public synchronized void invoke(int n, Slot slot, Value value) throws Exception {
        if (!Component.testMode) {
            slot.assertValue(value);
        }
        Msg msg = Msg.prepareRequest(105);
        msg.u2(n);
        msg.u1(slot.id);
        if (value != null) {
            value.encodeBinary(msg);
        }
        Msg msg2 = this.request(msg);
        msg2.checkResponse(73);
    }

    public synchronized void write(SoxComponent soxComponent, Slot slot, Value value) throws Exception {
        this.checkMine(soxComponent);
        this.write(soxComponent.id, slot, value);
    }

    public synchronized void write(int n, Slot slot, Value value) throws Exception {
        if (!Component.testMode) {
            slot.assertValue(value);
        }
        Msg msg = Msg.prepareRequest(119);
        msg.u2(n);
        msg.u1(slot.id);
        value.encodeBinary(msg);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(87);
    }

    public synchronized SoxComponent add(SoxComponent soxComponent, Type type, String string, Value[] valueArray) throws Exception {
        int n;
        Component.assertName(string);
        this.checkMine(soxComponent);
        if (soxComponent == null || soxComponent.client != this) {
            throw new IllegalArgumentException("Invalid parent");
        }
        if (soxComponent.children.length >= 200) {
            throw new IllegalArgumentException("Too many children under component");
        }
        if (type.schema != this.util.schema) {
            throw new IllegalArgumentException("Type's schema doesn't match client: " + type.schema.toString() + " != " + this.util.schema.toString());
        }
        Slot[] slotArray = type.configProps();
        if (slotArray.length != valueArray.length) {
            throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + slotArray.length + " != " + valueArray.length + ")");
        }
        for (int i = 0; i < valueArray.length; ++i) {
            Slot slot = slotArray[i];
            n = valueArray[i].typeId();
            if (!(slot.isAsStr() ? n != 101 : slot.type.id != n)) continue;
            throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + slotArray[i].name + " " + slotArray[i].type + " != " + valueArray[i].getClass().getName() + ")");
        }
        Msg msg = Msg.prepareRequest(97);
        msg.u2(soxComponent.id);
        msg.u1(type.kit.id);
        msg.u1(type.id);
        msg.str(string);
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i].encodeBinary(msg);
        }
        Msg msg2 = this.request(msg);
        msg2.checkResponse(65);
        n = msg2.u2();
        SoxComponent soxComponent2 = new SoxComponent(this, n, type);
        this.cacheAdd(soxComponent2);
        soxComponent2.name = string;
        soxComponent2.parent = soxComponent.id;
        soxComponent2.setChildren(new int[0]);
        soxComponent.addChild(n);
        for (int i = 0; i < slotArray.length; ++i) {
            soxComponent2.set(slotArray[i], valueArray[i]);
        }
        return soxComponent2;
    }

    public synchronized void rename(SoxComponent soxComponent, String string) throws Exception {
        Component.assertName(string);
        this.checkMine(soxComponent);
        Msg msg = Msg.prepareRequest(110);
        msg.u2(soxComponent.id);
        msg.str(string);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(78);
        soxComponent.name = string;
    }

    public synchronized void reorder(SoxComponent soxComponent, int[] nArray) throws Exception {
        int n;
        int[] nArray2 = (int[])nArray.clone();
        if (soxComponent.children.length != nArray2.length) {
            throw new IllegalArgumentException("childrenIds.length wrong");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(nArray2.length * 3);
        for (n = 0; n < soxComponent.children.length; ++n) {
            hashMap.put(new Integer(soxComponent.children[n]), "x");
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (hashMap.remove(new Integer(nArray2[n])) != null) continue;
            throw new IllegalArgumentException("childrenIds don't match current");
        }
        if (hashMap.size() != 0) {
            throw new IllegalArgumentException("childrenIds don't match current");
        }
        Msg msg = Msg.prepareRequest(111);
        msg.u2(soxComponent.id);
        msg.u1(nArray2.length);
        for (int i = 0; i < nArray2.length; ++i) {
            msg.u2(nArray2[i]);
        }
        Msg msg2 = this.request(msg);
        msg2.checkResponse(79);
        soxComponent.children = nArray2;
    }

    public synchronized void delete(SoxComponent soxComponent) throws Exception {
        this.checkMine(soxComponent);
        Msg msg = Msg.prepareRequest(100);
        msg.u2(soxComponent.id);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(68);
        SoxComponent soxComponent2 = this.cache(soxComponent.parent);
        if (soxComponent2 != null) {
            soxComponent2.removeChild(soxComponent.id);
        }
        this.cacheRemove(soxComponent);
    }

    public synchronized void link(Link link) throws Exception {
        this.link(link, 97);
    }

    public synchronized void unlink(Link link) throws Exception {
        this.link(link, 100);
    }

    private synchronized void link(Link link, int n) throws Exception {
        Msg msg = Msg.prepareRequest(108);
        msg.u1(n);
        msg.u2(link.fromCompId);
        msg.u1(link.fromSlotId);
        msg.u2(link.toCompId);
        msg.u1(link.toSlotId);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(76);
    }

    public synchronized int[] queryService(Type type) throws Exception {
        int n;
        Msg msg = Msg.prepareRequest(113);
        msg.u1(115);
        msg.u1(type.kit.id);
        msg.u1(type.id);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(81);
        int[] nArray = new int[256];
        int n2 = 0;
        while ((n = msg2.u2()) != 65535) {
            nArray[n2++] = n;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getFile(String string, SoxFile soxFile, Properties properties, TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.getFile();
            return properties2;
        }
        finally {
            this.fileTransfer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties putFile(String string, SoxFile soxFile, Properties properties, TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.putFile();
            return properties2;
        }
        finally {
            this.fileTransfer = null;
        }
    }

    public synchronized void renameFile(String string, String string2) throws Exception {
        Msg msg = Msg.prepareRequest(98);
        msg.str(string);
        msg.str(string2);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(66);
    }

    public Buf readPstoreFile(SoxComponent soxComponent) throws Exception {
        SoxComponent soxComponent2 = this.load(soxComponent.parent);
        String string = "";
        try {
            string = this.readProp(soxComponent2, soxComponent2.slot("filename")).toString();
        }
        catch (Exception exception) {
            throw new Exception("PstoreFile parent not PstoreService: " + soxComponent2.type);
        }
        if (soxComponent.getInt("status") != 0) {
            throw new Exception("PstoreFile.status not ok");
        }
        int n = soxComponent.getInt("resvOffset");
        int n2 = soxComponent.getInt("resvSize");
        Buf buf = new Buf(n2);
        Properties properties = new Properties();
        properties.put("fileSize", Integer.toString(n2));
        properties.put("offset", Integer.toString(n));
        this.getFile(string, SoxFile.make(buf), properties, null);
        if (buf.size != n2) {
            throw new IOException("Didn't read all of pstore: " + n2 + " != " + buf.size);
        }
        return buf;
    }

    void applyToCache(Msg msg) throws Exception {
        boolean bl = msg.command() == 101;
        int n = msg.u2();
        int n2 = msg.u1();
        SoxComponent soxComponent = this.cache(n);
        SoxComponent soxComponent2 = this.util.apply(msg, n, n2, soxComponent);
        if (soxComponent == null) {
            this.cacheAdd(soxComponent2);
        }
        if (bl) {
            this.applyEvent(soxComponent2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyEvent(SoxComponent soxComponent, int n) {
        if (soxComponent == null) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 116: {
                n2 = 1;
                break;
            }
            case 67: 
            case 99: {
                n2 = 2;
                break;
            }
            case 82: 
            case 114: {
                n2 = 4;
                break;
            }
            case 108: {
                n2 = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown event: " + (char)n);
            }
        }
        if ((soxComponent.subscription & n2) == 0) {
            Object object = this.subscribeSyncLock;
            synchronized (object) {
                soxComponent.subscription |= n2;
                this.subscribeSyncLock.notifyAll();
            }
        }
    }

    private SoxComponent cache(int n) {
        if (0 <= n && n < this.cache.length) {
            return this.cache[n];
        }
        return null;
    }

    private void cacheAdd(SoxComponent soxComponent) {
        if (soxComponent.id >= this.cache.length) {
            SoxComponent[] soxComponentArray = new SoxComponent[Math.max(this.cache.length * 2, soxComponent.id + 32)];
            System.arraycopy(this.cache, 0, soxComponentArray, 0, this.cache.length);
            this.cache = soxComponentArray;
        }
        this.cache[soxComponent.id] = soxComponent;
    }

    private void cacheRemove(SoxComponent soxComponent) {
        int[] nArray = soxComponent.childrenIds();
        for (int i = 0; i < nArray.length; ++i) {
            SoxComponent soxComponent2 = this.cache(nArray[i]);
            if (soxComponent2 == null) continue;
            this.cacheRemove(soxComponent2);
        }
        this.cache[soxComponent.id] = null;
    }

    private void checkMine(SoxComponent soxComponent) {
        if (soxComponent.client != this) {
            throw new IllegalArgumentException("SoxComponent.client != this client");
        }
    }

    private void checkMine(SoxComponent[] soxComponentArray) {
        for (int i = 0; i < soxComponentArray.length; ++i) {
            this.checkMine(soxComponentArray[i]);
        }
    }

    Msg request(Msg msg) throws Exception {
        return this.requests(new Msg[]{msg})[0];
    }

    Msg[] requests(Msg[] msgArray) throws Exception {
        this.checkOpen();
        return this.exchange.request(msgArray);
    }

    void send(Msg msg) throws Exception {
        this.checkOpen();
        if (this.traceMsg) {
            System.out.println("--> [send] " + (char)msg.command() + " replyNum=" + msg.replyNum());
        }
        this.session.send(msg.bytes, 0, msg.size);
    }

    Msg receive(long l) throws Exception {
        DaspMessage daspMessage = this.session.receive(l);
        if (daspMessage == null) {
            return null;
        }
        Msg msg = new Msg(daspMessage.payload());
        if (this.traceMsg) {
            System.out.println("<-- [recv] " + (char)msg.command() + " replyNum=" + msg.replyNum());
        }
        return msg;
    }

    void checkOpen() {
        if (this.isClosed()) {
            throw new SoxException("SoxClient closed: " + this.closeCause);
        }
    }

    public void initOptions() {
        try {
            this.traceMsg = Env.getProperty("sox.traceMsg", this.traceMsg);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void printOptions() {
        this.printOptions(new PrintWriter(System.out));
    }

    public void printOptions(PrintWriter printWriter) {
        printWriter.println("  traceMsg        = " + this.traceMsg);
        printWriter.flush();
    }

    public static interface TransferListener {
        public void progress(int var1, int var2);
    }

    public static interface Listener {
        public void soxClientClosed(SoxClient var1);
    }
}

