/*
 * Decompiled with CFR 0.152.
 */
package sedona.kit;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import sedona.Depend;
import sedona.Env;
import sedona.kit.KitFile;
import sedona.manifest.KitManifest;
import sedona.util.Version;

public class KitDb {
    public static final File dir = new File(Env.home, "kits");

    public static File toDir(String string) {
        return new File(dir, string);
    }

    public static File toFile(String string, int n, Version version) {
        return new File(KitDb.toDir(string), string + "-" + Integer.toHexString(n) + "-" + version + ".kit");
    }

    public static File toFile(KitManifest kitManifest) {
        return KitDb.toFile(kitManifest.name, kitManifest.checksum, kitManifest.version);
    }

    public static String[] kits() {
        File[] fileArray = dir.listFiles();
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            arrayList.add(fileArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static KitFile[] list(String string) {
        File[] fileArray = KitDb.toDir(string).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return new KitFile[0];
        }
        ArrayList<KitFile> arrayList = new ArrayList<KitFile>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!KitFile.isKitFile(file)) continue;
            arrayList.add(new KitFile(file));
        }
        Object[] objectArray = arrayList.toArray(new KitFile[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static KitFile[] matchAll(Depend depend) {
        KitFile[] kitFileArray = KitDb.list(depend.name());
        ArrayList<KitFile> arrayList = new ArrayList<KitFile>();
        for (int i = 0; i < kitFileArray.length; ++i) {
            if (!depend.match(kitFileArray[i].version, kitFileArray[i].checksum)) continue;
            arrayList.add(kitFileArray[i]);
        }
        return arrayList.toArray(new KitFile[arrayList.size()]);
    }

    public static KitFile matchBest(String string) {
        return KitDb.matchBest(Depend.parse(string + " 0+"));
    }

    public static KitFile matchBest(Depend depend) {
        KitFile[] kitFileArray = KitDb.list(depend.name());
        KitFile kitFile = null;
        for (int i = 0; i < kitFileArray.length; ++i) {
            if (!depend.match(kitFileArray[i].version, kitFileArray[i].checksum)) continue;
            kitFile = KitFile.best(kitFile, kitFileArray[i]);
        }
        return kitFile;
    }
}

