/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.io.PrintWriter;
import sedona.dasp.DaspConst;
import sedona.dasp.DaspSession;
import sedona.util.TextUtil;

public class DaspMessage
implements DaspConst {
    private static final byte[] noBytes = new byte[0];
    int sessionId = -1;
    int msgType = -1;
    int seqNum = -1;
    int version = -1;
    int remoteId = -1;
    String digestAlgorithm;
    byte[] nonce;
    String username;
    byte[] digest;
    int idealMax = -1;
    int absMax = -1;
    int ack = -1;
    byte[] ackMore;
    int receiveMax = -1;
    long receiveTimeout = -1L;
    int errorCode = -1;
    byte[] payload = noBytes;
    DaspMessage next;
    DaspSession session;

    public DaspSession session() {
        return this.session;
    }

    public byte[] payload() {
        return this.payload;
    }

    public String toString() {
        return "DaspMessage @ " + this.session + " (" + this.payload.length + " bytes)";
    }

    int version() {
        if (this.version == -1) {
            throw new RuntimeException("Missing version header field");
        }
        return this.version;
    }

    int remoteId() {
        if (this.remoteId == -1) {
            throw new RuntimeException("Missing remoteId header field");
        }
        return this.remoteId;
    }

    String digestAlgorithm() {
        if (this.digestAlgorithm == null) {
            return "SHA-1";
        }
        return this.digestAlgorithm;
    }

    byte[] nonce() {
        if (this.nonce == null) {
            throw new RuntimeException("Missing nonce header field");
        }
        return this.nonce;
    }

    String username() {
        if (this.username == null) {
            throw new RuntimeException("Missing username header field");
        }
        return this.username;
    }

    byte[] digest() {
        if (this.digest == null) {
            throw new RuntimeException("Missing digest header field");
        }
        return this.digest;
    }

    int idealMax() {
        if (this.idealMax == -1) {
            return 512;
        }
        return this.idealMax;
    }

    int absMax() {
        if (this.absMax == -1) {
            return 512;
        }
        return this.absMax;
    }

    int receiveMax() {
        if (this.receiveMax == -1) {
            return 31;
        }
        return this.receiveMax;
    }

    long receiveTimeout() {
        if (this.receiveTimeout == -1L) {
            return 30000L;
        }
        return this.receiveTimeout;
    }

    int encode(byte[] byArray) {
        int n = 0;
        n = this.u2(n, byArray, this.sessionId);
        n = this.u2(n, byArray, this.seqNum);
        ++n;
        boolean bl = this.idealMax != -1 && this.idealMax != 512;
        boolean bl2 = this.absMax != -1 && this.absMax != 512;
        boolean bl3 = this.receiveMax != -1 && this.receiveMax != 31;
        boolean bl4 = this.receiveTimeout != -1L && this.receiveTimeout != 30000L;
        int n2 = 0;
        if (this.version != -1) {
            ++n2;
            byArray[n++] = 5;
            n = this.u2(n, byArray, this.version);
        }
        if (this.remoteId != -1) {
            ++n2;
            byArray[n++] = 9;
            n = this.u2(n, byArray, this.remoteId);
        }
        if (this.digestAlgorithm != null) {
            ++n2;
            byArray[n++] = 14;
            n = this.str(n, byArray, this.digestAlgorithm);
        }
        if (this.nonce != null) {
            ++n2;
            byArray[n++] = 19;
            n = this.bytes(n, byArray, this.nonce);
        }
        if (this.username != null) {
            ++n2;
            byArray[n++] = 22;
            n = this.str(n, byArray, this.username);
        }
        if (this.digest != null) {
            ++n2;
            byArray[n++] = 27;
            n = this.bytes(n, byArray, this.digest);
        }
        if (bl) {
            ++n2;
            byArray[n++] = 29;
            n = this.u2(n, byArray, this.idealMax);
        }
        if (bl2) {
            ++n2;
            byArray[n++] = 33;
            n = this.u2(n, byArray, this.absMax);
        }
        if (this.ack != -1) {
            ++n2;
            byArray[n++] = 37;
            n = this.u2(n, byArray, this.ack);
        }
        if (this.ackMore != null) {
            ++n2;
            byArray[n++] = 43;
            n = this.bytes(n, byArray, this.ackMore);
        }
        if (bl3) {
            ++n2;
            byArray[n++] = 45;
            n = this.u2(n, byArray, this.receiveMax);
        }
        if (bl4) {
            ++n2;
            byArray[n++] = 49;
            n = this.u2(n, byArray, (int)(this.receiveTimeout / 1000L));
        }
        if (this.errorCode != -1) {
            ++n2;
            byArray[n++] = 53;
            n = this.u2(n, byArray, this.errorCode);
        }
        byArray[4] = (byte)(this.msgType << 4 | n2);
        if (this.payload != null) {
            System.arraycopy(this.payload, 0, byArray, n, this.payload.length);
            n += this.payload.length;
        }
        return n;
    }

    private int u2(int n, byte[] byArray, int n2) {
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        return n;
    }

    private int bytes(int n, byte[] byArray, byte[] byArray2) {
        byArray[n++] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    private int str(int n, byte[] byArray, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new RuntimeException("String must be ASCII " + string);
            }
            byArray[n++] = (byte)c;
        }
        byArray[n++] = 0;
        return n;
    }

    DaspMessage decode(byte[] byArray, int n) throws Exception {
        this.sessionId = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.seqNum = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.msgType = (byArray[4] & 0xFF) >> 4;
        int n2 = byArray[4] & 0xF;
        int n3 = 5;
        block21: for (int i = 0; i < n2; ++i) {
            byte by = byArray[n3++];
            int n4 = 0;
            String string = null;
            byte[] byArray2 = null;
            switch (by & 3) {
                case 0: {
                    break;
                }
                case 1: {
                    n4 = (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
                    break;
                }
                case 2: {
                    int n5 = n3;
                    while (byArray[n3++] != 0) {
                    }
                    string = new String(byArray, n5, n3 - n5 - 1, "UTF-8");
                    break;
                }
                case 3: {
                    int n6 = byArray[n3++] & 0xFF;
                    byArray2 = n6 == 0 ? noBytes : new byte[n6];
                    System.arraycopy(byArray, n3, byArray2, 0, n6);
                }
            }
            switch (by) {
                case 5: {
                    this.version = n4;
                    continue block21;
                }
                case 9: {
                    this.remoteId = n4;
                    continue block21;
                }
                case 14: {
                    this.digestAlgorithm = string;
                    continue block21;
                }
                case 19: {
                    this.nonce = byArray2;
                    continue block21;
                }
                case 22: {
                    this.username = string;
                    continue block21;
                }
                case 27: {
                    this.digest = byArray2;
                    continue block21;
                }
                case 29: {
                    this.idealMax = n4;
                    continue block21;
                }
                case 33: {
                    this.absMax = n4;
                    continue block21;
                }
                case 37: {
                    this.ack = n4;
                    continue block21;
                }
                case 43: {
                    this.ackMore = byArray2;
                    continue block21;
                }
                case 45: {
                    this.receiveMax = n4;
                    continue block21;
                }
                case 49: {
                    this.receiveTimeout = (long)n4 * 1000L;
                    continue block21;
                }
                case 53: {
                    this.errorCode = n4;
                }
            }
        }
        this.payload = (n -= n3) == 0 ? noBytes : new byte[n];
        System.arraycopy(byArray, n3, this.payload, 0, n);
        return this;
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("sessionId=" + this.sessionId + " msgType=" + this.msgType + " seqNum=" + this.seqNum);
        if (this.version != -1) {
            printWriter.println("  version         = " + this.version);
        }
        if (this.remoteId != -1) {
            printWriter.println("  remoteId        = " + this.remoteId);
        }
        if (this.digestAlgorithm != null) {
            printWriter.println("  digestAlgorithm = " + this.digestAlgorithm);
        }
        if (this.nonce != null) {
            printWriter.println("  nonce           = " + DaspMessage.toString(this.nonce));
        }
        if (this.username != null) {
            printWriter.println("  username        = " + this.username);
        }
        if (this.digest != null) {
            printWriter.println("  digest          = " + DaspMessage.toString(this.digest));
        }
        if (this.idealMax != -1) {
            printWriter.println("  idealMax        = " + this.idealMax);
        }
        if (this.absMax != -1) {
            printWriter.println("  absMax          = " + this.absMax);
        }
        if (this.ack != -1) {
            printWriter.println("  ack             = " + this.ack);
        }
        if (this.ackMore != null) {
            printWriter.println("  ackMore         = " + this.ackMore);
        }
        if (this.receiveMax != -1) {
            printWriter.println("  receiveMax      = " + this.receiveMax);
        }
        if (this.receiveTimeout != -1L) {
            printWriter.println("  receiveTimeout  = " + this.receiveTimeout);
        }
        if (this.errorCode != -1) {
            printWriter.println("  errorCode       = " + this.errorCode);
        }
        printWriter.flush();
    }

    static String toString(byte[] byArray) {
        return DaspMessage.toString(byArray, byArray.length);
    }

    static String toString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x[");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(TextUtil.byteToHexString(byArray[i] & 0xFF));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

