/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Long
extends Value {
    static final Long[] predefined = new Long[256];
    static final Long ZERO;
    public final long val;

    public static Long make(long l) {
        if (0L <= l && l < (long)predefined.length) {
            return predefined[(int)l];
        }
        return new Long(l);
    }

    private Long(long l) {
        this.val = l;
    }

    @Override
    public int typeId() {
        return 5;
    }

    public int hashCode() {
        return (int)(this.val ^ this.val >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Long) {
            return this.val == ((Long)object).val;
        }
        return false;
    }

    @Override
    public String encodeString() {
        return String.valueOf(this.val);
    }

    @Override
    public Value decodeString(String string) {
        return Long.make(java.lang.Long.decode(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.i8(this.val);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        return Long.make(buf.i8());
    }

    static {
        for (int i = 0; i < predefined.length; ++i) {
            Long.predefined[i] = new Long(i);
        }
        ZERO = predefined[0];
    }
}

