/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.ArrayList;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Link;
import sedona.Long;
import sedona.Short;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;

public abstract class Component {
    public static final int nullId = 65535;
    public static final int maxChildren = 200;
    public static boolean testMode = false;
    public final Type type;
    Value[] slots;

    public Component(Type type) {
        if (type == null) {
            throw new NullPointerException("null type");
        }
        this.type = type;
        this.slots = new Value[type.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = type.slots[i].def();
        }
    }

    public abstract int id();

    public abstract String name();

    public abstract Component getParent();

    public abstract Component[] getChildren();

    public abstract Component getChild(String var1);

    public abstract Link[] links();

    public String path() {
        Object object;
        if (this.getParent() == null) {
            return "/";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (object = this; object != null; object = ((Component)object).getParent()) {
            arrayList.add(((Component)object).name());
        }
        object = new StringBuffer();
        int n = arrayList.size();
        for (int i = arrayList.size() - 2; i >= 0; --i) {
            ((StringBuffer)object).append('/').append(arrayList.get(i));
        }
        return ((StringBuffer)object).toString();
    }

    public String toString() {
        return this.type.qname + "[" + this.id() + " " + this.name() + "]";
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public Slot slot(String string) {
        return this.type.slot(string);
    }

    public Slot slot(String string, boolean bl) {
        return this.type.slot(string, bl);
    }

    public Value get(Slot slot) {
        return this.slots[slot.id];
    }

    public boolean getBool(Slot slot) {
        return ((Bool)this.get((Slot)slot)).val;
    }

    public int getInt(Slot slot) {
        switch (slot.type.id) {
            case 2: {
                return ((Byte)this.get((Slot)slot)).val;
            }
            case 3: {
                return ((Short)this.get((Slot)slot)).val;
            }
        }
        return ((Int)this.get((Slot)slot)).val;
    }

    public long getLong(Slot slot) {
        return ((Long)this.get((Slot)slot)).val;
    }

    public float getFloat(Slot slot) {
        return ((Float)this.get((Slot)slot)).val;
    }

    public double getDouble(Slot slot) {
        return ((Double)this.get((Slot)slot)).val;
    }

    public Buf getBuf(Slot slot) {
        return (Buf)this.get(slot);
    }

    public String getStr(Slot slot) {
        return ((Str)this.get((Slot)slot)).val;
    }

    public Value get(String string) {
        return this.get(this.slot(string, true));
    }

    public boolean getBool(String string) {
        return this.getBool(this.slot(string, true));
    }

    public int getInt(String string) {
        return this.getInt(this.slot(string, true));
    }

    public long getLong(String string) {
        return this.getLong(this.slot(string, true));
    }

    public float getFloat(String string) {
        return this.getFloat(this.slot(string, true));
    }

    public double getDouble(String string) {
        return this.getDouble(this.slot(string, true));
    }

    public Buf getBuf(String string) {
        return this.getBuf(this.slot(string, true));
    }

    public String getStr(String string) {
        return this.getStr(this.slot(string, true));
    }

    public void set(Slot slot, Value value) {
        if (!testMode) {
            slot.assertValue(value);
        }
        this.slots[slot.id] = value;
    }

    public void set(String string, Value value) {
        this.set(this.slot(string, true), value);
    }

    public void setBool(Slot slot, boolean bl) {
        this.set(slot, (Value)Bool.make(bl));
    }

    public void setInt(Slot slot, int n) {
        switch (slot.type.id) {
            case 2: {
                this.set(slot, (Value)Byte.make(n));
                break;
            }
            case 3: {
                this.set(slot, (Value)Short.make(n));
                break;
            }
            default: {
                this.set(slot, (Value)Int.make(n));
            }
        }
    }

    public void setLong(Slot slot, long l) {
        this.set(slot, (Value)Long.make(l));
    }

    public void setFloat(Slot slot, float f) {
        this.set(slot, (Value)Float.make(f));
    }

    public void setDouble(Slot slot, double d) {
        this.set(slot, (Value)Double.make(d));
    }

    public void setBuf(Slot slot, Buf buf) {
        this.set(slot, (Value)buf);
    }

    public void setStr(Slot slot, String string) {
        this.set(slot, (Value)Str.make(string));
    }

    public void setBool(String string, boolean bl) {
        this.setBool(this.slot(string, true), bl);
    }

    public void setInt(String string, int n) {
        this.setInt(this.slot(string, true), n);
    }

    public void setLong(String string, long l) {
        this.setLong(this.slot(string, true), l);
    }

    public void setFloat(String string, float f) {
        this.setFloat(this.slot(string, true), f);
    }

    public void setDouble(String string, double d) {
        this.setDouble(this.slot(string, true), d);
    }

    public void setBuf(String string, Buf buf) {
        this.setBuf(this.slot(string, true), buf);
    }

    public void setStr(String string, String string2) {
        this.setStr(this.slot(string, true), string2);
    }

    public static void assertName(String string) {
        String string2 = Component.checkName(string);
        if (string2 == null) {
            return;
        }
        throw new IllegalArgumentException("Invalid name \"" + string + "\" (" + string2 + ")");
    }

    public static String checkName(String string) {
        if (string.length() > 31) {
            return "nameTooLong";
        }
        if (string.length() == 0) {
            return "nameEmpty";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') continue;
            if (i == 0) {
                return "invalidFirstChar";
            }
            if ('0' <= c && c <= '9' || c == '_') continue;
            return "invalidChar";
        }
        return null;
    }
}

