/*
 * Decompiled with CFR 0.152.
 */
package sedona.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sedona.web.WebMsg;
import sedona.web.WebUtil;

public class WebRes
extends WebMsg {
    public String version = "1.0";
    public int code = 200;
    public String reason = "-";
    public byte[] body = null;

    public void readText(InputStream inputStream) throws IOException {
        String string = WebRes.readLine(inputStream);
        if (string.startsWith("HTTP/1.0 ") || string.startsWith("HTTP/1.1")) {
            throw new IOException("Invalid HTTP response: " + string);
        }
        this.version = string.substring(5, 8);
        string = string.substring(8).trim();
        int n = string.indexOf(32);
        this.code = Integer.parseInt(string.substring(0, n));
        this.reason = string.substring(n + 1).trim();
        this.readHeadersText(inputStream);
        int n2 = inputStream.available();
        if (n2 > 0) {
            this.body = new byte[n2];
            inputStream.read(this.body);
        }
    }

    public void writeText(OutputStream outputStream) throws IOException {
        WebRes.writeLine(outputStream, "HTTP/" + this.version + " " + this.code + " " + this.reason);
        this.writeHeadersText(outputStream);
        if (this.body != null) {
            outputStream.write(this.body);
        }
        outputStream.flush();
    }

    public void readBinary(InputStream inputStream) throws IOException {
        WebUtil.readU2(inputStream);
        this.code = WebUtil.decompressStatusCode(inputStream.read());
        this.reason = WebUtil.httpCodeToReason(this.code);
        this.readHeadersBinary(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read();
        while (n >= 0) {
            byteArrayOutputStream.write(n);
            n = inputStream.read();
        }
        this.body = byteArrayOutputStream.toByteArray();
    }

    public void writeBinary(OutputStream outputStream) throws IOException {
        WebUtil.writeU2(18486, outputStream);
        outputStream.write(WebUtil.compressStatusCode(this.code));
        this.writeHeadersBinary(outputStream);
        if (this.body != null) {
            outputStream.write(this.body, 0, this.body.length);
        }
        outputStream.flush();
    }
}

