/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import sedona.Env;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxException;

class SoxExchange {
    SoxClient client;
    Msg[] requests;
    Msg[] responses;

    SoxExchange(SoxClient soxClient) {
        this.client = soxClient;
    }

    Msg[] request(Msg[] msgArray) throws Exception {
        if (msgArray.length > 255) {
            return this.chunkRequests(msgArray);
        }
        char c = (char)msgArray[0].command();
        SoxExchange soxExchange = this;
        synchronized (soxExchange) {
            int n;
            for (int i = 0; i < msgArray.length; ++i) {
                msgArray[i].setReplyNum(i);
            }
            this.requests = msgArray;
            this.responses = new Msg[msgArray.length];
            long l = Env.ticks();
            long l2 = 0L;
            for (n = 0; n < msgArray.length; ++n) {
                this.client.send(msgArray[n]);
            }
            while (true) {
                n = 1;
                for (int i = this.responses.length - 1; i >= 0; --i) {
                    if (this.responses[i] != null) continue;
                    n = 0;
                    break;
                }
                if (n != 0) {
                    Msg[] msgArray2 = this.responses;
                    this.requests = null;
                    this.responses = null;
                    return msgArray2;
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.client.checkOpen();
            }
        }
    }

    private Msg[] chunkRequests(Msg[] msgArray) throws Exception {
        Msg[] msgArray2;
        int n = msgArray.length;
        Msg[] msgArray3 = new Msg[n];
        for (int i = 0; i < n; i += msgArray2.length) {
            msgArray2 = new Msg[Math.min(255, n - i)];
            System.arraycopy(msgArray, i, msgArray2, 0, msgArray2.length);
            Msg[] msgArray4 = this.request(msgArray2);
            System.arraycopy(msgArray4, 0, msgArray3, i, msgArray4.length);
        }
        return msgArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(Msg msg) {
        try {
            SoxExchange soxExchange = this;
            synchronized (soxExchange) {
                int n;
                byte by = msg.bytes[0];
                int n2 = n = msg.bytes[1] & 0xFF;
                if (this.requests == null || this.responses == null || n2 < 0 || n2 >= this.requests.length) {
                    return;
                }
                Msg msg2 = this.requests[n2];
                if (by != 33 && by != (msg2.bytes[0] & 0xFFFFFFDF)) {
                    throw new SoxException("Invalid response code " + by + " for " + msg2.bytes[0]);
                }
                this.responses[n2] = msg;
                this.notify();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.client.close();
        }
    }
}

