/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import sedona.dasp.DaspMessage;

final class ReceiveQueue {
    private DaspMessage head;
    private DaspMessage tail;
    private int size;
    private int peak;
    private String blocked;
    private boolean isAlive = true;
    private int max;

    ReceiveQueue(int n) {
        this.max = n;
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized int size() {
        return this.size;
    }

    public final int peak() {
        return this.peak;
    }

    public final int max() {
        return this.max;
    }

    public final synchronized void kill() {
        this.isAlive = false;
        this.notifyAll();
    }

    public synchronized DaspMessage dequeue(long l) throws InterruptedException {
        DaspMessage daspMessage;
        while (this.isAlive && this.size == 0 && l != 0L) {
            if (l == -1L) {
                this.wait();
                continue;
            }
            this.wait(l);
            break;
        }
        if ((daspMessage = this.head) == null) {
            return null;
        }
        this.head = daspMessage.next;
        if (this.head == null) {
            this.tail = null;
        }
        daspMessage.next = null;
        --this.size;
        this.notifyAll();
        return daspMessage;
    }

    public synchronized void enqueue(DaspMessage daspMessage) throws FullException {
        if (this.isAlive && this.size >= this.max()) {
            throw new FullException();
        }
        if (daspMessage.next != null) {
            throw new IllegalStateException();
        }
        if (this.tail == null) {
            this.head = this.tail = daspMessage;
        } else {
            this.tail.next = daspMessage;
            this.tail = daspMessage;
        }
        ++this.size;
        if (this.size > this.peak) {
            this.peak = this.size;
        }
        this.notifyAll();
    }

    public synchronized void clear() {
        this.size = 0;
        this.head = null;
        this.tail = null;
        this.notifyAll();
    }

    public String toString() {
        String string = "MsgQueue size=" + this.size + " peak=" + this.peak + " max=" + this.max();
        if (this.blocked != null) {
            string = string + " blocked=" + this.blocked;
        }
        return string;
    }

    static class FullException
    extends Exception {
        FullException() {
        }
    }
}

