/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;
import sedona.util.TextUtil;

public final class Str
extends Value {
    static final Str empty = new Str("");
    public final String val;

    public static Str make(String string) {
        if (string.length() == 0) {
            return empty;
        }
        return new Str(string);
    }

    private Str(String string) {
        this.val = string;
    }

    @Override
    public int typeId() {
        return 101;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Str) {
            return this.val.equals(((Str)object).val);
        }
        return false;
    }

    public boolean isAscii() {
        for (int i = 0; i < this.val.length(); ++i) {
            char c = this.val.charAt(i);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    @Override
    public String encodeString() {
        return TextUtil.toLiteral(this.val);
    }

    @Override
    public Value decodeString(String string) {
        return Str.make(TextUtil.fromLiteral(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.u2(this.val.length() + 1);
        for (int i = 0; i < this.val.length(); ++i) {
            buf.u1(this.val.charAt(i));
        }
        buf.u1(0);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        int n = buf.u2();
        if (n == 0) {
            return empty;
        }
        char[] cArray = new char[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            cArray[i] = (char)buf.u1();
        }
        String string = new String(cArray);
        if (buf.u1() != 0) {
            throw new IOException("Str not null terminated: " + string);
        }
        return Str.make(string);
    }

    @Override
    public String toCode() {
        return '\"' + TextUtil.toLiteral(this.val) + '\"';
    }
}

