/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.ArrayList;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XWriter;

public class Depend {
    private final String name;
    private final Constraint[] constraints;

    public static Depend parse(String string) {
        try {
            return new Parser(string).parse();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid Depend: '" + string + "'");
        }
    }

    public static Depend makeChecksum(String string, int n) {
        Constraint constraint = new Constraint();
        constraint.checksum = n;
        return new Depend(string, new Constraint[]{constraint});
    }

    private Depend(String string, Constraint[] constraintArray) {
        this.name = string;
        this.constraints = constraintArray;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Depend) {
            return object.toString().equals(this.toString());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(' ');
        for (int i = 0; i < this.constraints.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            Constraint constraint = this.constraints[i];
            if (constraint.version == null) {
                stringBuffer.append("0x").append(Integer.toHexString(constraint.checksum));
                continue;
            }
            stringBuffer.append(constraint.version);
            if (constraint.isPlus) {
                stringBuffer.append('+');
            }
            if (constraint.isExact) {
                stringBuffer.append('=');
            }
            if (constraint.endVersion == null) continue;
            stringBuffer.append('-').append(constraint.endVersion);
        }
        return stringBuffer.toString();
    }

    public int size() {
        return this.constraints.length;
    }

    public Version version(int n) {
        return this.constraints[n].version;
    }

    public boolean isPlus(int n) {
        return this.constraints[n].isPlus;
    }

    public boolean isExact(int n) {
        return this.constraints[n].isExact;
    }

    public boolean isRange(int n) {
        return this.constraints[n].endVersion != null;
    }

    public Version endVersion(int n) {
        return this.constraints[n].endVersion;
    }

    public int checksum(int n) {
        return this.constraints[n].checksum;
    }

    public boolean match(Version version) {
        return this.match(version, -1);
    }

    public boolean match(int n) {
        return this.match(null, n);
    }

    public boolean match(Version version, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < this.constraints.length; ++i) {
            Constraint constraint = this.constraints[i];
            if (constraint.checksum != -1) {
                bl2 = n != -1;
            } else {
                boolean bl5 = bl = version != null;
            }
            if (n != -1) {
                bl4 |= this.matchChecksum(constraint, n);
            }
            if (version == null) continue;
            bl3 |= this.matchVersion(constraint, version);
        }
        if (bl) {
            if (bl2) {
                return bl3 & bl4;
            }
            return bl3;
        }
        return bl4;
    }

    private boolean matchChecksum(Constraint constraint, int n) {
        return constraint.checksum == n;
    }

    private boolean matchVersion(Constraint constraint, Version version) {
        if (constraint.version == null) {
            return false;
        }
        if (constraint.isPlus) {
            return constraint.version.compareTo(version) <= 0;
        }
        if (constraint.isExact) {
            return constraint.version.compareTo(version) == 0;
        }
        if (constraint.endVersion != null) {
            return constraint.version.compareTo(version) <= 0 && (constraint.endVersion.compareTo(version) >= 0 || Depend.doMatch(constraint.endVersion, version));
        }
        return Depend.doMatch(constraint.version, version);
    }

    private static boolean doMatch(Version version, Version version2) {
        if (version.size() > version2.size()) {
            return false;
        }
        for (int i = 0; i < version.size(); ++i) {
            if (version.get(i) == version2.get(i)) continue;
            return false;
        }
        return true;
    }

    public void encodeXml(XWriter xWriter) {
        xWriter.w("  <depend ").attr("on", this.toString()).w("/>\n");
    }

    public static Depend decodeXml(XElem xElem) {
        return Depend.parse(xElem.get("on"));
    }

    static class Constraint {
        Version version;
        boolean isPlus;
        boolean isExact;
        Version endVersion;
        int checksum = -1;

        Constraint() {
        }
    }

    static class Parser {
        int cur;
        int pos;
        int len;
        String str;
        String name;
        ArrayList constraints = new ArrayList(4);

        Parser(String string) {
            this.str = string;
            this.len = string.length();
            this.consume();
        }

        Depend parse() {
            this.name = this.name();
            this.constraints.add(this.constraint());
            while (this.cur == 44) {
                this.consume();
                this.consumeSpaces();
                this.constraints.add(this.constraint());
            }
            if (this.pos <= this.len) {
                throw new RuntimeException();
            }
            return new Depend(this.name, this.constraints.toArray(new Constraint[this.constraints.size()]));
        }

        private String name() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.cur != 32) {
                if (this.cur < 0) {
                    throw new RuntimeException();
                }
                stringBuffer.append((char)this.cur);
                this.consume();
            }
            this.consumeSpaces();
            if (stringBuffer.length() == 0) {
                throw new RuntimeException();
            }
            return stringBuffer.toString();
        }

        private Constraint constraint() {
            Constraint constraint = new Constraint();
            if (this.cur == 48 && this.peek() == 120) {
                constraint.checksum = this.checksum();
                return constraint;
            }
            constraint.version = this.version();
            this.consumeSpaces();
            if (this.cur == 43) {
                constraint.isPlus = true;
                this.consume();
                this.consumeSpaces();
            } else if (this.cur == 61) {
                constraint.isExact = true;
                this.consume();
                this.consumeSpaces();
            } else if (this.cur == 45) {
                this.consume();
                this.consumeSpaces();
                constraint.endVersion = this.version();
                this.consumeSpaces();
            }
            return constraint;
        }

        private Version version() {
            int[] nArray = new int[8];
            int n = this.consumeDigit();
            int n2 = 0;
            while (true) {
                if (48 <= this.cur && this.cur <= 57) {
                    n = n * 10 + this.consumeDigit();
                    continue;
                }
                nArray[n2++] = n;
                n = 0;
                if (this.cur != 46) break;
                this.consume();
            }
            return new Version(nArray, n2);
        }

        private int checksum() {
            int n;
            this.consume();
            this.consume();
            int n2 = 0;
            while ((n = this.consumeHexDigit()) >= 0) {
                n2 = n2 << 4 | n;
            }
            return n2;
        }

        private int consumeDigit() {
            if (48 <= this.cur && this.cur <= 57) {
                int n = this.cur - 48;
                this.consume();
                return n;
            }
            throw new RuntimeException();
        }

        private int consumeHexDigit() {
            if (48 <= this.cur && this.cur <= 57) {
                int n = this.cur - 48;
                this.consume();
                return n;
            }
            if (97 <= this.cur && this.cur <= 102) {
                int n = this.cur - 97 + 10;
                this.consume();
                return n;
            }
            if (65 <= this.cur && this.cur <= 70) {
                int n = this.cur - 65 + 10;
                this.consume();
                return n;
            }
            return -1;
        }

        private void consumeSpaces() {
            while (this.cur == 32) {
                this.consume();
            }
        }

        private int peek() {
            if (this.pos >= this.len) {
                return -1;
            }
            return this.str.charAt(this.pos);
        }

        private void consume() {
            if (this.pos < this.len) {
                this.cur = this.str.charAt(this.pos++);
            } else {
                this.cur = -1;
                this.pos = this.len + 1;
            }
        }
    }
}

