/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.zip.CRC32;
import sedona.Value;
import sedona.util.Base64;
import sedona.util.TextUtil;

public class Buf
extends Value
implements Comparable {
    public int size;
    public byte[] bytes;
    public int pos;
    public boolean bigEndian = true;
    public boolean checkAlignment = false;

    public Buf(byte[] byArray, int n) {
        this.size = n;
        this.bytes = byArray;
    }

    public Buf(byte[] byArray) {
        this.size = byArray.length;
        this.bytes = byArray;
    }

    public Buf(int n) {
        this.bytes = new byte[n];
    }

    public Buf() {
        this(256);
    }

    @Override
    public int typeId() {
        return 8;
    }

    public int hashCode() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.bytes, 0, this.size);
        long l = cRC32.getValue();
        return (int)(l ^ l >>> 32);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Buf)) {
            return false;
        }
        Buf buf = (Buf)object;
        if (this.size != buf.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.bytes[i] == buf.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public String encodeString() {
        return Base64.encode(this.trim());
    }

    @Override
    public Value decodeString(String string) {
        return new Buf(Base64.decode(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.u2(this.size);
        buf.write(this.bytes, 0, this.size);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        int n = buf.u2();
        byte[] byArray = new byte[n];
        if (buf.read(byArray) != n) {
            throw new IOException("unexpected end of file " + n);
        }
        return new Buf(byArray);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("0x[");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(TextUtil.byteToHexString(this.bytes[i] & 0xFF));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Buf fromString(String string) {
        if (!string.startsWith("0x[") || !string.endsWith("]")) {
            throw new IllegalArgumentException("Not a Buf literal: " + string);
        }
        Buf buf = new Buf();
        for (int i = 3; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            int n = TextUtil.hexCharToInt(c);
            int n2 = TextUtil.hexCharToInt(string.charAt(++i));
            buf.write(n << 4 | n2);
        }
        return buf;
    }

    public void clear() {
        this.pos = 0;
        this.size = 0;
    }

    public void seek(int n) {
        this.pos = n;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.bytes[n] & 0xFF;
    }

    public void flip() {
        this.pos = 0;
    }

    public byte[] trim() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.bytes, 0, byArray, 0, this.size);
        return byArray;
    }

    public void write(int n) {
        this.grow(this.size + 1);
        this.bytes[this.size++] = (byte)n;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.grow(this.size + n2);
        System.arraycopy(byArray, n, this.bytes, this.size, n2);
        this.size += n2;
    }

    public void append(Buf buf) {
        this.grow(this.size + buf.size);
        System.arraycopy(buf.bytes, 0, this.bytes, this.size, buf.size);
        this.size += buf.size;
    }

    public void align(int n) {
        int n2 = this.size % n;
        if (n2 == 0) {
            return;
        }
        this.pad(n - n2);
    }

    public void pad(int n) {
        this.grow(this.size + n);
        for (int i = 0; i < n; ++i) {
            this.bytes[this.size++] = 0;
        }
    }

    private void grow(int n) {
        if (this.bytes.length < n) {
            n = Math.max(n, this.bytes.length * 2);
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
    }

    public void bool(boolean bl) {
        this.u1(bl ? 1 : 0);
    }

    public void u1(int n) {
        this.grow(this.size + 1);
        this.bytes[this.size++] = (byte)n;
    }

    public void u1(int n, int n2) {
        this.bytes[n] = (byte)n2;
    }

    public void s1(int n) {
        this.u1(n);
    }

    public void s1(int n, int n2) {
        this.u1(n, n2);
    }

    public void u2(int n) {
        this.u2(n, this.checkAlignment);
    }

    public void u2(int n, boolean bl) {
        if (bl && this.size % 2 != 0) {
            throw new RuntimeException("u2 not aligned (" + this.size + ")");
        }
        this.grow(this.size + 2);
        if (this.bigEndian) {
            this.bytes[this.size++] = (byte)(n >>> 8);
            this.bytes[this.size++] = (byte)(n >>> 0);
        } else {
            this.bytes[this.size++] = (byte)(n >>> 0);
            this.bytes[this.size++] = (byte)(n >>> 8);
        }
    }

    public void u2(int n, int n2) {
        this.u2(n, n2, this.checkAlignment);
    }

    public void u2(int n, int n2, boolean bl) {
        if (bl && n % 2 != 0) {
            throw new RuntimeException("u2 not aligned (" + n + ")");
        }
        if (this.bigEndian) {
            this.bytes[n + 0] = (byte)(n2 >>> 8);
            this.bytes[n + 1] = (byte)(n2 >>> 0);
        } else {
            this.bytes[n + 0] = (byte)(n2 >>> 0);
            this.bytes[n + 1] = (byte)(n2 >>> 8);
        }
    }

    public void u4(int n, int n2) {
        this.u4(n, n2, this.checkAlignment);
    }

    public void u4(int n, int n2, boolean bl) {
        if (bl && n % 4 != 0) {
            throw new RuntimeException("u4 not aligned (" + n + ")");
        }
        if (this.bigEndian) {
            this.bytes[n + 0] = (byte)(n2 >>> 24);
            this.bytes[n + 1] = (byte)(n2 >>> 16);
            this.bytes[n + 2] = (byte)(n2 >>> 8);
            this.bytes[n + 3] = (byte)(n2 >>> 0);
        } else {
            this.bytes[n + 0] = (byte)(n2 >>> 0);
            this.bytes[n + 1] = (byte)(n2 >>> 8);
            this.bytes[n + 2] = (byte)(n2 >>> 16);
            this.bytes[n + 3] = (byte)(n2 >>> 24);
        }
    }

    public void u4(int n) {
        this.u4(n, this.checkAlignment);
    }

    public void u4(int n, boolean bl) {
        if (bl && this.size % 4 != 0) {
            throw new RuntimeException("u4 not aligned (" + this.size + ")");
        }
        this.grow(this.size + 4);
        if (this.bigEndian) {
            this.bytes[this.size++] = (byte)(n >>> 24);
            this.bytes[this.size++] = (byte)(n >>> 16);
            this.bytes[this.size++] = (byte)(n >>> 8);
            this.bytes[this.size++] = (byte)(n >>> 0);
        } else {
            this.bytes[this.size++] = (byte)(n >>> 0);
            this.bytes[this.size++] = (byte)(n >>> 8);
            this.bytes[this.size++] = (byte)(n >>> 16);
            this.bytes[this.size++] = (byte)(n >>> 24);
        }
    }

    public void s2(int n) {
        this.u2(n);
    }

    public void s2(int n, int n2) {
        this.u2(n, n2);
    }

    public void i4(int n) {
        if (this.checkAlignment && this.size % 4 != 0) {
            throw new RuntimeException("i4 not aligned (" + this.size + ")");
        }
        this.grow(this.size + 4);
        if (this.bigEndian) {
            this.bytes[this.size++] = (byte)(n >>> 24);
            this.bytes[this.size++] = (byte)(n >>> 16);
            this.bytes[this.size++] = (byte)(n >>> 8);
            this.bytes[this.size++] = (byte)(n >>> 0);
        } else {
            this.bytes[this.size++] = (byte)(n >>> 0);
            this.bytes[this.size++] = (byte)(n >>> 8);
            this.bytes[this.size++] = (byte)(n >>> 16);
            this.bytes[this.size++] = (byte)(n >>> 24);
        }
    }

    public void i4(int n, int n2) {
        if (this.checkAlignment && n % 4 != 0) {
            throw new RuntimeException("i4 not aligned (" + n + ")");
        }
        if (this.bigEndian) {
            this.bytes[n + 0] = (byte)(n2 >>> 24);
            this.bytes[n + 1] = (byte)(n2 >>> 16);
            this.bytes[n + 2] = (byte)(n2 >>> 8);
            this.bytes[n + 3] = (byte)(n2 >>> 0);
        } else {
            this.bytes[n + 0] = (byte)(n2 >>> 0);
            this.bytes[n + 1] = (byte)(n2 >>> 8);
            this.bytes[n + 2] = (byte)(n2 >>> 16);
            this.bytes[n + 3] = (byte)(n2 >>> 24);
        }
    }

    public void i8(long l) {
        if (this.checkAlignment && this.size % 8 != 0) {
            throw new RuntimeException("i8 not aligned");
        }
        this.grow(this.size + 8);
        if (this.bigEndian) {
            this.bytes[this.size++] = (byte)(l >>> 56);
            this.bytes[this.size++] = (byte)(l >>> 48);
            this.bytes[this.size++] = (byte)(l >>> 40);
            this.bytes[this.size++] = (byte)(l >>> 32);
            this.bytes[this.size++] = (byte)(l >>> 24);
            this.bytes[this.size++] = (byte)(l >>> 16);
            this.bytes[this.size++] = (byte)(l >>> 8);
            this.bytes[this.size++] = (byte)(l >>> 0);
        } else {
            this.bytes[this.size++] = (byte)(l >>> 0);
            this.bytes[this.size++] = (byte)(l >>> 8);
            this.bytes[this.size++] = (byte)(l >>> 16);
            this.bytes[this.size++] = (byte)(l >>> 24);
            this.bytes[this.size++] = (byte)(l >>> 32);
            this.bytes[this.size++] = (byte)(l >>> 40);
            this.bytes[this.size++] = (byte)(l >>> 48);
            this.bytes[this.size++] = (byte)(l >>> 56);
        }
    }

    public void f4(float f) {
        this.i4(Float.floatToIntBits(f));
    }

    public void f8(double d) {
        this.i8(Double.doubleToLongBits(d));
    }

    public void str(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                throw new IllegalStateException("Not ASCII string: " + string);
            }
            this.u1(c);
        }
        this.u1(0);
    }

    public int available() {
        return this.size - this.pos;
    }

    public int peek() throws IOException {
        if (this.pos >= this.size) {
            throw new EOFException();
        }
        return this.bytes[this.pos] & 0xFF;
    }

    public int read() throws IOException {
        if (this.pos >= this.size) {
            return -1;
        }
        return this.bytes[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.pos >= this.size) {
            return -1;
        }
        int n3 = Math.min(n2, this.size - this.pos);
        System.arraycopy(this.bytes, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public int skipBytes(int n) throws IOException {
        this.pos += n;
        return n;
    }

    public boolean bool() throws IOException {
        return this.u1() != 0;
    }

    public int u1() throws IOException {
        if (this.pos >= this.size) {
            throw new EOFException();
        }
        return this.bytes[this.pos++] & 0xFF;
    }

    public int s1() throws IOException {
        return (byte)this.u1();
    }

    public int u2() throws IOException {
        if (this.bigEndian) {
            return (this.u1() << 8) + this.u1();
        }
        return this.u1() + (this.u1() << 8);
    }

    public int s2() throws IOException {
        if (this.bigEndian) {
            return (short)((this.u1() << 8) + this.u1());
        }
        return (short)(this.u1() + (this.u1() << 8));
    }

    public int i4() throws IOException {
        if (this.bigEndian) {
            return (this.u1() << 24) + (this.u1() << 16) + (this.u1() << 8) + (this.u1() << 0);
        }
        return (this.u1() << 0) + (this.u1() << 8) + (this.u1() << 16) + (this.u1() << 24);
    }

    public long i8() throws IOException {
        if (this.bigEndian) {
            return ((long)this.i4() << 32) + ((long)this.i4() & 0xFFFFFFFFL);
        }
        return ((long)this.i4() & 0xFFFFFFFFL) + ((long)this.i4() << 32);
    }

    public float f4() throws IOException {
        return Float.intBitsToFloat(this.i4());
    }

    public double f8() throws IOException {
        return Double.longBitsToDouble(this.i8());
    }

    public String str() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.u1()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public InputStream getInputStream() {
        return new InputStream(){

            @Override
            public final int available() throws IOException {
                return Buf.this.available();
            }

            @Override
            public final int read() throws IOException {
                return Buf.this.read();
            }

            @Override
            public final int read(byte[] byArray, int n, int n2) throws IOException {
                return Buf.this.read(byArray, n, n2);
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public final void write(int n) {
                Buf.this.write(n);
            }

            @Override
            public final void write(byte[] byArray, int n, int n2) {
                Buf.this.write(byArray, n, n2);
            }
        };
    }

    public int readFrom(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        this.grow(this.size + n);
        for (n2 = 0; n2 < n && (n3 = inputStream.read(this.bytes, this.pos + n2, n - n2)) >= 0; n2 += n3) {
        }
        this.size += n;
        return n2;
    }

    public void readFullyFrom(InputStream inputStream, int n) throws IOException {
        int n2;
        if (n < 0) {
            this.readToEnd(inputStream);
            return;
        }
        this.grow(n);
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(this.bytes, this.pos + i, n - i);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
        this.size += n;
    }

    public void readToEnd(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
            this.write(byArray, 0, n);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes, 0, this.size);
    }

    public void writeTo(OutputStream outputStream, int n, int n2) throws IOException {
        if (n2 > this.size) {
            throw new IOException("len > internal buffer");
        }
        outputStream.write(this.bytes, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buf readFrom(File file) throws IOException {
        int n = (int)file.length();
        Buf buf = new Buf(n);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            buf.readFullyFrom(bufferedInputStream, n);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.writeTo(bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public void readFrom(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.grow(this.size + n);
        randomAccessFile.readFully(this.bytes, this.size, n);
        this.size += n;
    }

    public void writeTo(RandomAccessFile randomAccessFile, int n) throws IOException {
        if (this.pos + n > this.size) {
            throw new IOException("Unexpected end of buf pos=" + this.pos + " size=" + this.size + " n=" + n);
        }
        randomAccessFile.write(this.bytes, this.pos, n);
        this.pos += n;
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        Buf.hexDump(printWriter, this.bytes, 0, this.size);
        printWriter.flush();
    }

    public String dumpToString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Buf.hexDump(printWriter, this.bytes, 0, this.size);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static void hexDump(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        int n3 = 0;
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < n2; i += n3) {
            int n4;
            n3 = Math.min(16, n2 - i);
            System.arraycopy(byArray, n + i, byArray2, 0, n3);
            String string = Integer.toHexString(i + n);
            printWriter.print(TextUtil.padLeft(string, 3));
            printWriter.print(':');
            for (n4 = 0; n4 < 16; ++n4) {
                if (n4 % 4 == 0) {
                    printWriter.print(' ');
                }
                if (n4 >= n3) {
                    printWriter.print("  ");
                    continue;
                }
                printWriter.print(TextUtil.byteToHexString(byArray2[n4] & 0xFF));
            }
            printWriter.print("  ");
            for (n4 = 0; n4 < n3; ++n4) {
                printWriter.print(TextUtil.byteToChar(byArray2[n4] & 0xFF, '.'));
            }
            printWriter.println();
        }
    }
}

