/*
 * Decompiled with CFR 0.152.
 */
package sedona.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sedona.xml.XException;

public class XWriter
extends Writer {
    private static String[] SPACES = new String[50];
    private OutputStream sink;
    private Writer xout;
    private ZipOutputStream zout;
    private boolean zipped;
    private int numWritten;

    public XWriter(File file) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public XWriter(OutputStream outputStream) {
        this.sink = outputStream;
    }

    public XWriter w(Object object) {
        this.write(String.valueOf(object));
        return this;
    }

    public final XWriter w(boolean bl) {
        this.write(String.valueOf(bl));
        return this;
    }

    public final XWriter w(char c) {
        this.write(c);
        return this;
    }

    public final XWriter w(int n) {
        this.write(String.valueOf(n));
        return this;
    }

    public final XWriter w(long l) {
        this.write(String.valueOf(l));
        return this;
    }

    public final XWriter w(float f) {
        this.write(String.valueOf(f));
        return this;
    }

    public final XWriter w(double d) {
        this.write(String.valueOf(d));
        return this;
    }

    public final XWriter nl() {
        this.write(10);
        return this;
    }

    public final XWriter indent(int n) {
        this.write(XWriter.getSpaces(n));
        return this;
    }

    public final XWriter attr(String string, Object object) {
        return this.attr(string, String.valueOf(object));
    }

    public final XWriter attr(String string, boolean bl) {
        return this.attr(string, String.valueOf(bl));
    }

    public final XWriter attr(String string, int n) {
        return this.attr(string, String.valueOf(n));
    }

    public final XWriter attr(String string, long l) {
        return this.attr(string, String.valueOf(l));
    }

    public final XWriter attr(String string, float f) {
        return this.attr(string, String.valueOf(f));
    }

    public final XWriter attr(String string, double d) {
        return this.attr(string, String.valueOf(d));
    }

    public final XWriter attr(String string, String string2) {
        this.write(string);
        this.write(61);
        this.write(34);
        this.safe(string2);
        this.write(34);
        return this;
    }

    public XWriter prolog() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        return this;
    }

    public final XWriter safe(String string, boolean bl) {
        try {
            XWriter.safe(this.xout, string, bl);
            return this;
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    public final XWriter safe(String string) {
        try {
            XWriter.safe(this.xout, string, true);
            return this;
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    public final XWriter safe(int n, boolean bl) {
        try {
            XWriter.safe((Writer)this, n, bl);
            return this;
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    public static void safe(Writer writer, String string, boolean bl) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            XWriter.safe(writer, string.charAt(i), bl);
        }
    }

    public static void safe(Writer writer, int n, boolean bl) throws IOException {
        if (n < 32 || n > 126 || n == 39 || n == 34) {
            if (!bl) {
                if (n == 10) {
                    writer.write(10);
                    return;
                }
                if (n == 13) {
                    writer.write(13);
                    return;
                }
                if (n == 9) {
                    writer.write(9);
                    return;
                }
            }
            writer.write("&#x");
            writer.write(Integer.toHexString(n));
            writer.write(59);
        } else if (n == 60) {
            writer.write("&lt;");
        } else if (n == 62) {
            writer.write("&gt;");
        } else if (n == 38) {
            writer.write("&amp;");
        } else {
            writer.write((char)n);
        }
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public void setZipped(boolean bl) throws IOException {
        if (this.numWritten != 0) {
            throw new IllegalStateException("Cannot setZipped after data has been written");
        }
        this.zipped = bl;
    }

    @Override
    public void write(int n) {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            ++this.numWritten;
            this.xout.write(n);
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.numWritten += cArray.length;
            this.xout.write(cArray);
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.numWritten += n2;
            this.xout.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void write(String string) {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.numWritten += string.length();
            this.xout.write(string);
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.numWritten += n2;
            this.xout.write(string, n, n2);
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void flush() {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.xout.flush();
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.xout == null) {
                this.initOut();
            }
            this.xout.close();
        }
        catch (IOException iOException) {
            throw this.error(iOException);
        }
    }

    void initOut() throws IOException {
        if (this.zipped) {
            this.zout = new ZipOutputStream(this.sink);
            this.zout.putNextEntry(new ZipEntry("file.xml"));
            this.xout = new OutputStreamWriter((OutputStream)this.zout, "UTF8");
        } else {
            this.xout = new OutputStreamWriter(this.sink, "UTF8");
        }
    }

    XException error(IOException iOException) {
        throw new XException(iOException.toString(), null, iOException);
    }

    static String getSpaces(int n) {
        try {
            return SPACES[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < 0) {
                return "";
            }
            int n2 = SPACES.length;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n3 = n;
            while (true) {
                if (n3 < n2) break;
                stringBuffer.append(SPACES[n2 - 1]);
                n3 -= n2 - 1;
            }
            stringBuffer.append(SPACES[n3]);
            return stringBuffer.toString();
        }
    }

    static {
        XWriter.SPACES[0] = "";
        for (int i = 1; i < 50; ++i) {
            XWriter.SPACES[i] = SPACES[i - 1] + " ";
        }
    }
}

