/*
 * Decompiled with CFR 0.152.
 */
package sedona.vm;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import sedona.Depend;
import sedona.Env;
import sedona.Kit;
import sedona.KitPart;
import sedona.Schema;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.offline.OfflineApp;
import sedona.util.FileUtil;
import sedona.vm.Context;
import sedona.vm.SedonaClassLoader;
import sedona.vm.StrRef;
import sedona.vm.VmUtil;

public class Jsvm {
    protected final File sab;
    protected String[] args;
    protected String mainClass;
    private Schema schema;

    public static void main(String[] stringArray) {
        try {
            if (Jsvm.needHelp(stringArray)) {
                Jsvm.usage();
                return;
            }
            String string = stringArray[0];
            if (string.equals("-ver")) {
                Env.printVersion("Sedona Runtime for Java");
                return;
            }
            if (string.equals("-test")) {
                Jsvm.runTests();
                return;
            }
            if (string.equals("-testloop")) {
                Jsvm.runTestLoop();
                return;
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            System.exit(new Jsvm(new File(string), stringArray2).runJsvm());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    static boolean needHelp(String[] stringArray) {
        if (stringArray.length == 0) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-?") && !string.equals("-help")) continue;
            return true;
        }
        return false;
    }

    public static void usage() {
        Jsvm.println("usage:");
        Jsvm.println("  jsvm <app>  run sab or sax application");
        Jsvm.println("  jsvm -test  run test suite");
        Jsvm.println("  jsvm -ver   print version information");
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public Jsvm(File file) throws Exception {
        this(file, new String[0]);
    }

    public Jsvm(File file, String[] stringArray) throws Exception {
        this.sab = this.loadSchema(file);
        this.args = stringArray;
        this.mainClass = "sedona.vm.sys.Sys";
    }

    private File loadSchema(File file) throws Exception {
        File file2 = file;
        if (file.getName().endsWith(".sax")) {
            file2 = new File(file.getParentFile(), FileUtil.getBase(file.getName()) + ".sab");
            System.out.println("Converting " + file.getName() + " -> " + file2);
            OfflineApp.decodeApp(file).encodeAppBinary(file2);
        }
        this.schema = OfflineApp.decodeApp((File)file2).schema;
        return file2;
    }

    public final Schema getSchema() {
        return this.schema;
    }

    protected SedonaClassLoader newClassLoader(Context context) throws Exception {
        return new SedonaClassLoader(this.getSchema(), context);
    }

    public final void setMainClass(String string) {
        this.mainClass = string;
    }

    public final int runJsvm() throws Throwable {
        return this.runJsvm(new Context());
    }

    public final int runJsvm(Context context) throws Throwable {
        try {
            SedonaClassLoader sedonaClassLoader = this.newClassLoader(context);
            Jsvm.bootstrap(this.schema, sedonaClassLoader);
            Method method = Jsvm.findMethod(sedonaClassLoader.loadClass(this.mainClass), "main");
            return (Integer)method.invoke(null, this.sedonaArgs());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    protected Object[] sedonaArgs() {
        StrRef[] strRefArray = new StrRef[this.args.length + 1];
        strRefArray[0] = VmUtil.strConst(this.sab.getAbsolutePath());
        for (int i = 0; i < this.args.length; ++i) {
            strRefArray[i + 1] = VmUtil.strConst(this.args[i]);
        }
        return new Object[]{strRefArray, new Integer(strRefArray.length)};
    }

    static void bootstrap(Schema schema, ClassLoader classLoader) throws Exception {
        int n;
        HashMap<String, KitManifest> hashMap = new HashMap<String, KitManifest>();
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < schema.kits.length; ++n) {
            Kit kit = schema.kits[n];
            hashMap.put(kit.name, ManifestDb.load(new KitPart(kit.name, kit.checksum)));
            hashSet.add(kit.name);
        }
        for (n = 0; n < schema.kits.length; ++n) {
            Jsvm.doBootstrap(schema.kits[n].name, hashSet, hashMap, classLoader);
        }
    }

    static void doBootstrap(String string, HashSet hashSet, HashMap hashMap, ClassLoader classLoader) throws Exception {
        if (!hashSet.contains(string)) {
            return;
        }
        Depend[] dependArray = ((KitManifest)hashMap.get((Object)string)).depends;
        for (int i = 0; i < dependArray.length; ++i) {
            if (!hashSet.contains(dependArray[i].name())) continue;
            Jsvm.doBootstrap(dependArray[i].name(), hashSet, hashMap, classLoader);
        }
        Jsvm.findMethod(classLoader.loadClass("sedona.vm." + string + ".JsvmBootstrap"), "bootstrap").invoke(null, (Object[])null);
        hashSet.remove(string);
    }

    static Object[] toSedonaArgs(String[] stringArray) {
        StrRef[] strRefArray = new StrRef[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            strRefArray[i] = VmUtil.strConst(stringArray[i]);
        }
        return new Object[]{strRefArray, new Integer(stringArray.length)};
    }

    static Method findMethod(Class clazz, String string) throws Exception {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            return methodArray[i];
        }
        throw new IllegalStateException("Cannot find method in " + clazz.getName() + "." + string);
    }

    public static void runTests() throws Throwable {
        KitPart[] kitPartArray = new KitPart[]{KitPart.forLocalKit("sys"), KitPart.forLocalKit("inet"), KitPart.forLocalKit("sox"), KitPart.forLocalKit("web"), KitPart.forLocalKit("control")};
        Schema schema = Schema.load(kitPartArray);
        SedonaClassLoader sedonaClassLoader = new SedonaClassLoader(schema);
        Jsvm.bootstrap(schema, sedonaClassLoader);
        Jsvm.runTests(sedonaClassLoader, true);
    }

    public static void runTests(SedonaClassLoader sedonaClassLoader, boolean bl) throws Throwable {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < sedonaClassLoader.schema.kits.length; ++n) {
            String[] stringArray = sedonaClassLoader.reflector.kitTests(sedonaClassLoader.schema.kits[n]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (Jsvm.runTest(sedonaClassLoader, stringArray[i], bl)) continue;
                arrayList.add(stringArray[i]);
            }
        }
        if (bl) {
            System.out.println();
            for (n = 0; n < arrayList.size(); ++n) {
                System.out.println("FAILED: " + arrayList.get(n));
            }
            System.out.println();
            System.out.println("Assert Successes: " + VmUtil.assertSuccess);
            System.out.println("Assert Failures:  " + VmUtil.assertFailure);
            System.out.println();
        }
    }

    static boolean runTest(SedonaClassLoader sedonaClassLoader, String string, boolean bl) {
        if (bl) {
            System.out.print("-- Test " + string + " ");
        }
        if (bl) {
            System.out.flush();
        }
        int n = VmUtil.assertFailure;
        int n2 = VmUtil.assertSuccess;
        try {
            int n3 = string.indexOf(46);
            String string2 = string.substring(0, n3);
            String string3 = string.substring(n3 + 1);
            Class clazz = sedonaClassLoader.reflector.typeClass(string2);
            Method method = clazz.getMethod(string3, new Class[0]);
            method.invoke(null, new Object[0]);
            int n4 = VmUtil.assertSuccess - n2;
            int n5 = VmUtil.assertFailure - n;
            if (bl && n5 == 0) {
                System.out.println("(" + n4 + ")");
            }
            return n5 == 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = throwable.getCause();
            }
            System.out.println();
            System.out.println("FAILED: " + string);
            throwable2.printStackTrace();
            return false;
        }
    }

    public static void runTestLoop() throws Throwable {
        KitPart[] kitPartArray = new KitPart[]{KitPart.forLocalKit("sys")};
        Schema schema = Schema.load(kitPartArray);
        SedonaClassLoader sedonaClassLoader = new SedonaClassLoader(schema);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 5000; ++i) {
            Jsvm.runTests(sedonaClassLoader, false);
        }
        long l2 = System.currentTimeMillis();
        VmUtil.assertFailure = 0;
        VmUtil.assertSuccess = 0;
        System.out.println("Warmup: 5000 loops in " + (l2 - l) + "ms");
        int n = 10000;
        long l3 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            Jsvm.runTests(sedonaClassLoader, false);
        }
        long l4 = System.currentTimeMillis();
        System.out.println("JVM: " + n + " loops in " + (l4 - l3) + "ms");
        System.out.println();
        System.out.println("Assert Successes: " + VmUtil.assertSuccess);
        System.out.println("Assert Failures:  " + VmUtil.assertFailure);
    }
}

