/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import sedona.util.Log;

public class FileUtil {
    public static String getBase(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static byte[] read(InputStream inputStream, long l) throws IOException {
        int n;
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IOException("Invalid size " + l);
        }
        int n2 = (int)l;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            n = inputStream.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new IOException("Unexpected EOF");
        }
        inputStream.close();
        return byArray;
    }

    public static void pipe(InputStream inputStream, long l, OutputStream outputStream) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        while (l > 0L) {
            int n2 = inputStream.read(byArray, 0, (int)Math.min(l, (long)n));
            if (n2 <= 0) {
                throw new IOException("Unexpected EOF");
            }
            outputStream.write(byArray, 0, n2);
            l -= (long)n2;
        }
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 4096;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static String[] readLines(File file) throws IOException {
        return FileUtil.readLines(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void mkdir(File file, Log log) throws IOException {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (log != null) {
            log.debug("    MakeDir [" + file + "]");
        }
        if (!file.mkdirs()) {
            throw new IOException("Cannot make directory: " + file);
        }
    }

    public static void copy(File file, File file2, Log log) throws IOException {
        if (log != null) {
            log.debug("    Copy [" + file + " -> " + file2 + "]");
        }
        if (file2.exists()) {
            throw new IOException("Cannot copy to existing file: " + file2);
        }
        if (file.isDirectory()) {
            FileUtil.copyDir(file, file2, log);
        } else {
            FileUtil.copyFile(file, file2);
        }
    }

    public static void copyDir(File file, File file2, Log log) throws IOException {
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot make dir: " + file2);
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            FileUtil.copy(fileArray[i], new File(file2, fileArray[i].getName()), log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file2);
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4096];
            long l = file.length();
            for (long i = 0L; i < l; i += (long)n) {
                n = fileInputStream.read(byArray, 0, byArray.length);
                if (n < 0) {
                    throw new EOFException("Early EOF in input file");
                }
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void delete(File file, Log log) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (log != null) {
            log.debug("    Delete [" + file + "]");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.delete(fileArray[i], log);
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete: " + file);
        }
    }
}

