/*
 * Decompiled with CFR 0.152.
 */
package sedona.platform;

import sedona.Depend;
import sedona.platform.NativeManifest;
import sedona.util.VendorUtil;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class PlatformManifest {
    public String id;
    public String vendor;
    public String endian;
    public boolean armDouble;
    public int refSize;
    public int blockSize;
    public boolean debug;
    public boolean test;
    public Depend[] nativeKits;
    public NativeManifest[] nativeMethods;
    public XElem manifestIncludes;

    public PlatformManifest() {
        this(null);
    }

    public PlatformManifest(String string) {
        this.id = string;
        this.nativeKits = new Depend[0];
        this.nativeMethods = new NativeManifest[0];
        this.manifestIncludes = new XElem("manifestIncludes");
    }

    public static PlatformManifest decodeXml(XElem xElem) {
        if (!xElem.name().equals("platformManifest")) {
            throw new XException("Expected root to be <platformManifest>", xElem);
        }
        PlatformManifest platformManifest = new PlatformManifest();
        platformManifest.id = xElem.get("platformId", null);
        platformManifest.vendor = xElem.get("vendor");
        platformManifest.endian = xElem.get("endian");
        platformManifest.blockSize = xElem.geti("blockSize");
        platformManifest.refSize = xElem.geti("refSize");
        platformManifest.armDouble = xElem.getb("armDouble");
        platformManifest.debug = xElem.getb("debug");
        platformManifest.test = xElem.getb("test");
        XElem[] xElemArray = xElem.elem("natives", true).elems("nativeKit");
        platformManifest.nativeKits = new Depend[xElemArray.length];
        for (int i = 0; i < xElemArray.length; ++i) {
            platformManifest.nativeKits[i] = Depend.parse(xElemArray[i].get("depend"));
        }
        XElem[] xElemArray2 = xElem.elem("natives", true).elems("nativeMethod");
        platformManifest.nativeMethods = new NativeManifest[xElemArray2.length];
        for (int i = 0; i < xElemArray2.length; ++i) {
            platformManifest.nativeMethods[i] = NativeManifest.decodeXml(platformManifest, xElemArray2[i]);
        }
        platformManifest.manifestIncludes = xElem.elem("manifestIncludes");
        return platformManifest;
    }

    public void encodeXml(XWriter xWriter) {
        int n;
        xWriter.w("<?xml version='1.0'?>\n");
        xWriter.w("<platformManifest\n");
        if (this.id != null) {
            xWriter.w("    ").attr("platformId", this.id).w("\n");
        }
        if (this.vendor != null) {
            xWriter.w("    ").attr("vendor", this.vendor).w("\n");
        }
        if (this.endian != null) {
            xWriter.w("    ").attr("endian", this.endian).w("\n");
        }
        xWriter.w("    ").attr("blockSize", this.blockSize).w("\n");
        xWriter.w("    ").attr("refSize", this.refSize).w("\n");
        xWriter.w("    ").attr("armDouble", this.armDouble).w("\n");
        xWriter.w("    ").attr("debug", this.debug).w("\n");
        xWriter.w("    ").attr("test", this.test).w("\n");
        xWriter.w(">\n");
        xWriter.w("\n");
        xWriter.w("<!-- Natives -->\n");
        xWriter.w("<natives>\n");
        for (n = 0; n < this.nativeKits.length; ++n) {
            xWriter.w("  ").w("<nativeKit ").attr("depend", this.nativeKits[n].toString()).w(" />\n");
        }
        xWriter.w("\n");
        for (n = 0; n < this.nativeMethods.length; ++n) {
            this.nativeMethods[n].encodeXml(xWriter);
        }
        xWriter.w("</natives>").nl().nl();
        this.manifestIncludes.write(xWriter);
        xWriter.nl();
        xWriter.w("</platformManifest>\n");
    }

    public static void validate(PlatformManifest platformManifest) throws Exception {
        if (platformManifest == null) {
            throw new Exception("null manifest");
        }
        if (platformManifest.id == null) {
            throw new Exception("manifest doesn't specify a platform id");
        }
        if (platformManifest.vendor == null) {
            throw new Exception("manifest doesn't specify a vendor");
        }
        VendorUtil.checkVendorName(platformManifest.vendor);
        VendorUtil.checkPlatformPrefix(platformManifest.vendor, platformManifest.id);
        if (platformManifest.id.length() >= 128) {
            throw new Exception("platform id '" + platformManifest.id + "' must be less than 128 characters long: " + platformManifest.id.length());
        }
    }
}

