/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.Hashtable;
import sedona.Env;
import sedona.dasp.DaspConst;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DaspTestHooks;
import sedona.dasp.ReceiveQueue;
import sedona.dasp.ReceiveWindow;
import sedona.dasp.SendWindow;

public class DaspSession
implements DaspConst {
    static final boolean CLIENT = true;
    static final boolean SERVER = false;
    public final int id;
    public final boolean isClient;
    public final boolean isServer;
    public final DaspSocket socket;
    public final InetAddress host;
    public final int port;
    public final DaspTestHooks test;
    public final DaspSocketInterface iface;
    public Object userData;
    public Listener listener;
    public boolean traceSend;
    public boolean traceReceive;
    int remoteId;
    volatile boolean isClosed;
    int numSent;
    int numReceived;
    int numRetries;
    String closeCause = "???";
    String user;
    String pass;
    byte[] nonce;
    ReceiveQueue receiveQueue;
    ReceiveWindow receiveWindow;
    SendWindow sendWindow;
    long connectTimeout;
    int remoteReceiveMax;
    int idealMax;
    int absMax;
    long receiveTimeout;
    long connectTime;
    long lastSend;
    long lastReceive;

    DaspSession(DaspSocketInterface daspSocketInterface, int n, InetAddress inetAddress, int n2, boolean bl, Hashtable hashtable) {
        this.socket = daspSocketInterface.daspSocket;
        this.iface = daspSocketInterface;
        this.id = n;
        this.host = inetAddress;
        this.port = n2;
        this.isClient = bl;
        this.isServer = !bl;
        this.receiveQueue = new ReceiveQueue(DaspSession.option(hashtable, "dasp.sessionQueueMax", 2000));
        this.receiveWindow = new ReceiveWindow(this);
        this.sendWindow = new SendWindow(this);
        this.idealMax = DaspSession.option(hashtable, "dasp.idealMax", 512);
        this.absMax = DaspSession.option(hashtable, "dasp.absMax", 512);
        this.receiveTimeout = DaspSession.option(hashtable, "dasp.receiveTimeout", 30000L);
        this.connectTimeout = DaspSession.option(hashtable, "dasp.connectTimeout", 10000L);
        this.sendWindow.sendRetry = DaspSession.option(hashtable, "dasp.sendRetry", 1000L);
        this.lastReceive = DaspSession.ticks();
        this.connectTime = DaspSession.ticks();
        this.test = (DaspTestHooks)hashtable.get("dasp.test");
        if (this.test != null) {
            this.test.session = this;
        }
    }

    static boolean option(Hashtable hashtable, String string, boolean bl) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return string2.equals("true");
        }
        return Env.getProperty(string, bl);
    }

    static int option(Hashtable hashtable, String string, int n) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return Env.getProperty(string, n);
    }

    static long option(Hashtable hashtable, String string, long l) {
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return Env.getProperty(string, l);
    }

    public int remoteId() {
        return this.remoteId;
    }

    public int idealMax() {
        return this.idealMax;
    }

    public int absMax() {
        return this.absMax;
    }

    public int localReceiveMax() {
        return 31;
    }

    public int remoteReceiveMax() {
        return this.remoteReceiveMax;
    }

    public long receiveTimeout() {
        return this.receiveTimeout;
    }

    public String toString() {
        return (this.isClient ? "Client [" : "Server [") + this.id + " -> " + this.remoteId + "]";
    }

    public void send(byte[] byArray) throws Exception {
        this.send(byArray, 0, byArray.length);
    }

    public void send(byte[] byArray, int n, int n2) throws Exception {
        if (this.isClosed) {
            throw new DaspException("DaspSession is closed: " + this.closeCause);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.sendWindow.send(byArray2);
    }

    public DaspMessage receive(long l) throws Exception {
        if (this.socket.qMode != 14) {
            throw new IllegalStateException("not using session queuing mode");
        }
        DaspMessage daspMessage = this.receiveQueue.dequeue(l);
        if (this.isClosed) {
            throw new DaspException("DaspSession is closed: " + this.closeCause);
        }
        if (daspMessage == null) {
            return null;
        }
        if (daspMessage.msgType != 6) {
            throw new DaspException("Invalid message received: " + daspMessage.msgType);
        }
        return daspMessage;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.close(-1, "close() api");
    }

    public String closeCause() {
        return this.closeCause;
    }

    void close(int n, String string) {
        if (this.isClosed) {
            return;
        }
        DaspMessage daspMessage = new DaspMessage();
        daspMessage.msgType = 7;
        daspMessage.sessionId = this.remoteId;
        daspMessage.seqNum = 65535;
        if (n != Integer.MAX_VALUE) {
            daspMessage.errorCode = n;
            if (n == 225) {
                daspMessage.version = 256;
            }
        }
        this.send(daspMessage);
        if (n == -1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.send(daspMessage);
        }
        this.shutdown(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(String string) {
        DaspSession daspSession = this;
        synchronized (daspSession) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.closeCause = string;
            try {
                if (this.listener != null) {
                    this.listener.daspSessionClosed(this);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.socket.free(this);
            this.sendWindow.kill();
            this.receiveQueue.kill();
        }
    }

    void connect() throws Exception {
        DaspMessage daspMessage = this.hello();
        DaspMessage daspMessage2 = null;
        switch (daspMessage.msgType) {
            case 7: {
                throw new DaspException("Connection denied", daspMessage.errorCode);
            }
            case 2: {
                this.remoteId = daspMessage.remoteId();
                daspMessage2 = this.authenticate(daspMessage);
                break;
            }
            case 4: {
                this.remoteId = daspMessage.remoteId();
                daspMessage2 = daspMessage;
                break;
            }
            default: {
                throw new DaspException("Unexpected response to hello " + daspMessage.msgType);
            }
        }
        switch (daspMessage2.msgType) {
            case 7: {
                throw new DaspException("Connection denied ", daspMessage2.errorCode);
            }
            case 4: {
                this.tune(daspMessage2);
                break;
            }
            default: {
                throw new DaspException("Expected welcome, not " + daspMessage2.msgType);
            }
        }
    }

    DaspMessage hello() throws Exception {
        DaspMessage daspMessage = new DaspMessage();
        daspMessage.msgType = 1;
        daspMessage.sessionId = 65535;
        daspMessage.seqNum = this.sendWindow.curSeqNum();
        daspMessage.remoteId = this.id;
        daspMessage.version = 256;
        daspMessage.idealMax = this.idealMax;
        daspMessage.absMax = this.absMax;
        daspMessage.receiveMax = this.localReceiveMax();
        daspMessage.receiveTimeout = this.receiveTimeout;
        long l = this.connectTimeout / 3L;
        if (l < 1000L) {
            l = 1000L;
        }
        for (int i = 0; i < 3; ++i) {
            this.send(daspMessage);
            DaspMessage daspMessage2 = this.receiveQueue.dequeue(l);
            if (daspMessage2 == null) continue;
            return daspMessage2;
        }
        throw new DaspException("No response from hello");
    }

    DaspMessage authenticate(DaspMessage daspMessage) throws Exception {
        int n = -1;
        String string = daspMessage.digestAlgorithm();
        if (string != "SHA-1") {
            this.close(227, "digest not supported");
            throw new DaspException("Unsupported algorithm", 227);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = messageDigest.digest((this.user + ":" + this.pass).getBytes("UTF-8"));
        messageDigest.reset();
        messageDigest.update(byArray);
        messageDigest.update(daspMessage.nonce());
        byte[] byArray2 = messageDigest.digest();
        DaspMessage daspMessage2 = new DaspMessage();
        daspMessage2.msgType = 3;
        daspMessage2.sessionId = this.remoteId;
        daspMessage2.seqNum = this.sendWindow.curSeqNum();
        daspMessage2.username = this.user;
        daspMessage2.digest = byArray2;
        long l = this.connectTimeout / 3L;
        if (l < 1000L) {
            l = 1000L;
        }
        for (int i = 0; i < 3; ++i) {
            this.send(daspMessage2);
            DaspMessage daspMessage3 = this.receiveQueue.dequeue(l);
            if (daspMessage3 == null) continue;
            return daspMessage3;
        }
        throw new DaspException("No response from authenticate");
    }

    void challenge(DaspMessage daspMessage) {
        this.remoteId = daspMessage.remoteId();
        if (daspMessage.version() != 256) {
            this.close(225, "incompatible version");
            return;
        }
        this.tune(daspMessage);
        this.nonce = new byte[10];
        for (int i = 0; i < this.nonce.length; ++i) {
            this.nonce[i] = (byte)this.socket.rand.nextInt();
        }
        DaspMessage daspMessage2 = new DaspMessage();
        daspMessage2.msgType = 2;
        daspMessage2.sessionId = this.remoteId;
        daspMessage2.seqNum = this.sendWindow.curSeqNum();
        daspMessage2.remoteId = this.id;
        daspMessage2.nonce = this.nonce;
        this.send(daspMessage2);
    }

    void welcome(DaspMessage daspMessage) {
        Object object;
        boolean bl = false;
        try {
            object = this.socket.acceptor.credentials(daspMessage.username());
            if (object != null) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update((byte[])object);
                messageDigest.update(this.nonce);
                byte[] byArray = messageDigest.digest();
                byte[] byArray2 = daspMessage.digest();
                bl = DaspSession.equals(byArray2, byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            this.close(228, "not authenticated");
            return;
        }
        object = new DaspMessage();
        object.msgType = 4;
        object.sessionId = this.remoteId;
        object.seqNum = this.sendWindow.curSeqNum();
        object.remoteId = this.id;
        object.idealMax = this.idealMax;
        object.absMax = this.absMax;
        object.receiveMax = this.localReceiveMax();
        object.receiveTimeout = this.receiveTimeout;
        this.send((DaspMessage)object);
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    void tune(DaspMessage daspMessage) {
        this.idealMax = Math.min(daspMessage.idealMax(), this.idealMax);
        this.absMax = Math.min(daspMessage.absMax(), this.absMax);
        this.remoteReceiveMax = daspMessage.receiveMax();
        this.receiveTimeout = Math.max(daspMessage.receiveTimeout(), this.receiveTimeout);
        this.sendWindow.sendSize = this.remoteReceiveMax;
        this.receiveWindow.init(daspMessage.seqNum);
    }

    void dispatch(DaspMessage daspMessage) {
        if (this.test != null && !this.test.receive(daspMessage.msgType, daspMessage.seqNum, daspMessage.payload)) {
            return;
        }
        ++this.numReceived;
        this.lastReceive = DaspSession.ticks();
        if (daspMessage.msgType == 3) {
            this.welcome(daspMessage);
            return;
        }
        this.sendWindow.checkAckHeaders(daspMessage);
        if (daspMessage.msgType == 6 && !this.receiveWindow.receive(daspMessage.seqNum)) {
            return;
        }
        switch (daspMessage.msgType) {
            case 2: 
            case 4: {
                this.enqueue(daspMessage);
                return;
            }
            case 7: {
                this.enqueue(daspMessage);
                this.shutdown("remote endpoint sent close (" + daspMessage.errorCode + ")");
                return;
            }
            case 6: {
                if (this.socket.qMode == 13) {
                    this.socket.enqueue(daspMessage);
                } else {
                    this.enqueue(daspMessage);
                }
                return;
            }
            case 5: {
                return;
            }
        }
        System.out.println("DaspSession unexpected msgType=" + daspMessage.msgType);
    }

    void enqueue(DaspMessage daspMessage) {
        try {
            this.receiveQueue.enqueue(daspMessage);
        }
        catch (ReceiveQueue.FullException fullException) {
            System.out.println("ERROR: DaspSession queue full!");
            this.close(229, "receive queue full");
        }
    }

    void houseKeeping() {
        if (DaspSession.ticks() - this.lastReceive > this.receiveTimeout) {
            this.close(229, "receive timeout");
            return;
        }
        long l = this.sendWindow.sendRetries();
        if (l > this.receiveTimeout) {
            this.close(229, "unacked send timeout");
            return;
        }
        if (this.receiveWindow.unacked() || DaspSession.ticks() - this.lastSend > this.receiveTimeout / 3L) {
            this.keepAlive();
        }
    }

    void keepAlive() {
        DaspMessage daspMessage = new DaspMessage();
        daspMessage.msgType = 5;
        daspMessage.sessionId = this.remoteId;
        daspMessage.seqNum = 65535;
        this.receiveWindow.setAckHeaders(daspMessage);
        this.send(daspMessage);
    }

    void send(DaspMessage daspMessage) {
        this.lastSend = DaspSession.ticks();
        if (this.test != null && !this.test.send(daspMessage.msgType, daspMessage.seqNum, daspMessage.payload)) {
            return;
        }
        this.socket.send(this, daspMessage);
    }

    static long ticks() {
        return Env.ticks();
    }

    public long uptime() {
        return DaspSession.ticks() - this.connectTime;
    }

    public long lastSend() {
        return this.lastSend;
    }

    public long lastReceive() {
        return this.lastReceive;
    }

    public int numSent() {
        return this.numSent;
    }

    public int numReceived() {
        return this.numReceived;
    }

    public int numRetries() {
        return this.numRetries;
    }

    public int sendWindowSize() {
        return this.sendWindow.sendSize;
    }

    public long sendWindowRetry() {
        return this.sendWindow.sendRetry;
    }

    public int[] ackTimes() {
        return (int[])this.sendWindow.ackTimes.clone();
    }

    public static interface Listener {
        public void daspSessionClosed(DaspSession var1);
    }
}

