/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Value;

public final class Short
extends Value {
    static final Short[] predefined = new Short[256];
    static final Short ZERO;
    static final Short MAX;
    public final int val;

    public static Short make(int n) {
        if (n < 0 || n > Short.MAX.val) {
            throw new IllegalArgumentException("Valid Short range [0-" + Short.MAX.val + "]: val = " + n);
        }
        if (n < predefined.length) {
            return predefined[n];
        }
        return new Short(n);
    }

    private Short(int n) {
        this.val = n;
    }

    @Override
    public int typeId() {
        return 3;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Short) {
            return this.val == ((Short)object).val;
        }
        return false;
    }

    @Override
    public String encodeString() {
        return String.valueOf(this.val);
    }

    @Override
    public Value decodeString(String string) {
        return Short.make(Integer.decode(string));
    }

    @Override
    public void encodeBinary(Buf buf) {
        buf.u2(this.val);
    }

    @Override
    public Value decodeBinary(Buf buf) throws IOException {
        return Short.make(buf.u2());
    }

    static {
        for (int i = 0; i < predefined.length; ++i) {
            Short.predefined[i] = new Short(i);
        }
        ZERO = predefined[0];
        MAX = new Short(65535);
    }
}

