/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.HashMap;
import sedona.Schema;
import sedona.Type;
import sedona.manifest.KitManifest;

public class Kit {
    public final Schema schema;
    public final int id;
    public final KitManifest manifest;
    public final String name;
    public final int checksum;
    public final Type[] types;
    final HashMap typesByName;

    Kit(Schema schema, int n, KitManifest kitManifest) throws Exception {
        this.schema = schema;
        this.id = n;
        this.manifest = kitManifest;
        this.name = kitManifest.name;
        this.checksum = kitManifest.checksum;
        this.types = new Type[kitManifest.types.length];
        this.typesByName = new HashMap(this.types.length * 3);
        for (int i = 0; i < this.types.length; ++i) {
            String string = kitManifest.types[i].qname;
            Type type = new Type(this, kitManifest.types[i]);
            if (type.id != i) {
                throw new Exception("Mismatched type id: " + string);
            }
            if (this.typesByName.get(type.name) != null) {
                throw new Exception("Duplicate type name: " + string);
            }
            this.types[i] = type;
            this.typesByName.put(type.name, type);
        }
    }

    public Type type(int n) {
        if (0 <= n & n < this.types.length) {
            return this.types[n];
        }
        return null;
    }

    public Type type(String string) {
        return (Type)this.typesByName.get(string);
    }

    public String toString() {
        return this.name;
    }
}

