/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import sedona.Buf;
import sedona.dasp.DaspAcceptor;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspTestHooks;
import sedona.util.UserUtil;
import sedonac.test.Test;

public class DaspTest
extends Test {
    DaspSocket socket;
    DaspSession client;
    DaspSession server;
    String user;
    String pass;
    InetAddress local;
    TestHooks clientHooks;
    TestHooks serverHooks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        System.out.println();
        DaspTestHooks.runWhiteboxTests();
        System.out.println();
        this.local = InetAddress.getLocalHost();
        try {
            this.startServer(14);
            this.verifyConnect();
            this.verifyDatagrams();
            this.verifyClose();
            this.startServer(13);
            this.verifyConnect();
            this.verifyDatagrams();
            this.verifyClose();
        }
        finally {
            this.stopServer();
        }
    }

    private void verifyConnect() throws Exception {
        DaspException daspException = null;
        this.trace("Connect with bad username...");
        this.user = "bob";
        this.pass = "secret";
        daspException = null;
        try {
            this.socket.connect(this.local, this.socket.port(), "x", "y");
        }
        catch (DaspException daspException2) {
            daspException = daspException2;
        }
        this.verifyEq(daspException.errorCode, 228);
        this.trace("Connect with bad password...");
        daspException = null;
        try {
            this.socket.connect(this.local, this.socket.port(), "bob", "bad");
        }
        catch (DaspException daspException3) {
            daspException = daspException3;
        }
        this.verifyEq(daspException.errorCode, 228);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("dasp.idealMax", "100");
        hashtable.put("dasp.absMax", "500");
        hashtable.put("dasp.receiveTimeout", "45000");
        hashtable.put("dasp.test", (Object)new TestHooks());
        this.trace("Connect...");
        this.client = this.socket.connect(this.local, this.socket.port(), "bob", "secret", hashtable);
        this.verify(!this.client.isClosed());
        this.verify(0 < this.client.id && this.client.id < 65535);
        this.verifyEq(this.client.host, this.local);
        this.verifyEq(this.client.port, this.socket.port());
        this.server = this.socket.session(this.client.remoteId());
        this.verify(this.server != null);
        this.verifyEq(this.server.remoteId(), this.client.id);
        this.verifyEq(this.server.host, this.local);
        this.verifyEq(this.server.port, this.socket.port());
        this.verifyEq(this.client.idealMax(), 100);
        this.verifyEq(this.client.absMax(), 500);
        this.verifyEq(this.client.localReceiveMax(), 31);
        this.verifyEq(this.client.remoteReceiveMax(), 31);
        this.verifyEq(this.client.receiveTimeout(), 45000L);
        this.verifyEq(this.server.idealMax(), 100);
        this.verifyEq(this.server.absMax(), 500);
        this.verifyEq(this.server.localReceiveMax(), 31);
        this.verifyEq(this.server.remoteReceiveMax(), 31);
        this.verifyEq(this.server.receiveTimeout(), 45000L);
    }

    private void verifyDatagrams() throws Exception {
        for (int i = 0; i < 23; ++i) {
            byte[] byArray = ("msg " + i).getBytes("UTF-8");
            this.client.send(byArray);
            this.verifyEq(this.receive(100L), byArray);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 23; ++i) {
            arrayList.add("msg " + i);
        }
        this.send(arrayList.toArray(new String[arrayList.size()]));
        while (arrayList.size() > 0) {
            byte[] byArray = this.receive(10000L);
            this.verify(byArray != null);
            String string = new String(byArray, "UTF-8");
            this.verify(arrayList.contains(string));
            arrayList.remove(string);
        }
        this.verify(true);
    }

    private byte[] receive(long l) throws Exception {
        DaspMessage daspMessage = this.socket.queuingMode() == 14 ? this.server.receive(l) : this.socket.receive(l);
        this.verify(daspMessage.session() == this.server);
        return daspMessage.payload();
    }

    private void send(final String[] stringArray) {
        Thread thread = new Thread("toSend async"){

            @Override
            public void run() {
                try {
                    TestHooks testHooks = (TestHooks)DaspTest.this.client.test;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i % 3 == 0) {
                            testHooks.addDrop(testHooks.sendSeqNum());
                        }
                        DaspTest.this.client.send(stringArray[i].getBytes("UTF-8"));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DaspTest.this.fail();
                }
            }
        };
        thread.start();
    }

    private void verifyClose() throws Exception {
        this.trace("Close...");
        this.verify(!this.client.isClosed());
        this.verify(!this.server.isClosed());
        this.client.close();
        this.verify(this.client.isClosed());
        this.pause();
        this.verify(this.server.isClosed());
    }

    void startServer(int n) throws Exception {
        this.socket = DaspSocket.open((int)-1, (DaspAcceptor)new DaspAcceptor(){

            public byte[] credentials(String string) {
                if (!string.equals(DaspTest.this.user)) {
                    return null;
                }
                return UserUtil.credentials((String)DaspTest.this.user, (String)DaspTest.this.pass);
            }

            public Hashtable options() {
                Hashtable<String, TestHooks> hashtable = new Hashtable<String, TestHooks>();
                hashtable.put("dasp.test", new TestHooks());
                return hashtable;
            }
        }, (int)n);
        this.verifyEq(this.socket.isClosed(), false);
        this.verifyEq(this.socket.sessions().length, 0);
        this.verifyEq(this.socket.queuingMode(), n);
    }

    void stopServer() throws Exception {
        this.socket.close();
        this.verifyEq(this.socket.isClosed(), true);
        this.verifyEq(this.socket.sessions().length, 0);
        IllegalStateException illegalStateException = null;
        try {
            this.socket.connect(this.local, 99, "x", "y");
        }
        catch (IllegalStateException illegalStateException2) {
            illegalStateException = illegalStateException2;
        }
        this.verifyEq(illegalStateException.getMessage(), "socket is closed");
    }

    public void trace(String string) {
        System.out.println("[>] " + string);
    }

    public void pause() throws Exception {
        Thread.sleep(100L);
    }

    static class TestHooks
    extends DaspTestHooks {
        int dropType = -1;
        int[] drop = new int[32];

        TestHooks() {
            this.clearDrop();
        }

        public void clearDrop() {
            for (int i = 0; i < this.drop.length; ++i) {
                this.drop[i] = -1;
            }
        }

        public void addDrop(int n) {
            for (int i = 0; i < this.drop.length; ++i) {
                if (this.drop[i] != -1) continue;
                this.drop[i] = n;
                return;
            }
            throw new IllegalStateException("drop list full!");
        }

        public boolean receive(int n, int n2, byte[] byArray) {
            return true;
        }

        public boolean send(int n, int n2, byte[] byArray) {
            if (n == this.dropType) {
                System.out.println("  DROPING msgType=" + n + " " + this.msgStr(byArray));
                this.dropType = -1;
                return false;
            }
            for (int i = 0; i < this.drop.length; ++i) {
                if (this.drop[i] != n2) continue;
                this.drop[i] = -1;
                System.out.println("  DROPING " + n2 + " " + this.msgStr(byArray));
                return false;
            }
            return true;
        }

        String msgStr(byte[] byArray) {
            try {
                Buf buf = new Buf(byArray);
                String string = (char)buf.u1() + " " + buf.u1();
                if (buf.bytes[0] == 107) {
                    string = string + " " + buf.u2() + " " + buf.u2();
                }
                return string;
            }
            catch (Exception exception) {
                return "";
            }
        }
    }
}

