/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import sedona.Buf;
import sedona.Float;
import sedona.KitPart;
import sedona.Schema;
import sedona.Str;
import sedona.Value;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.offline.OfflineLink;
import sedona.xml.XElem;
import sedona.xml.XParser;
import sedona.xml.XWriter;
import sedonac.test.Test;

public class AppTest
extends Test {
    Schema schema;
    OfflineApp app;
    OfflineComponent a;
    OfflineComponent b;
    OfflineComponent c;

    public void testIO() throws Exception {
        this.buildApp();
        this.verify(this.app.equivalent(this.app));
        this.verify(this.app.lookup(0) == this.app);
        this.verify(this.app.lookup(this.a.id()) == this.a);
        this.verify(this.app.lookup(this.c.id()) == this.c);
        this.verify(this.app.lookup("/") == this.app);
        this.verify(this.app.lookup("/a") == this.a);
        this.verify(this.app.lookup("/a/b") == this.b);
        this.verify(this.app.lookup("/a/c") == this.c);
        this.verify(this.app.lookup("/foo") == null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
        this.app.encodeAppXml(xWriter, false);
        xWriter.flush();
        XElem xElem = XParser.make((String)"buf", (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).parse();
        OfflineApp offlineApp = OfflineApp.decodeAppXml((XElem)xElem);
        this.verify(this.app.equivalent(offlineApp));
        Buf buf = this.app.encodeAppBinary();
        buf.flip();
        OfflineApp offlineApp2 = OfflineApp.decodeAppBinary((Buf)buf);
        this.verify(this.app.equivalent(offlineApp2));
    }

    public void testErrChecking() throws Exception {
        this.buildApp();
        Exception exception = null;
        try {
            this.a.set("bufB", (Value)Str.make((String)"foo"));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.verify(exception != null);
        exception = null;
        try {
            this.a.set("str", (Value)new Buf());
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        this.verify(exception != null);
        exception = null;
        try {
            this.a.set("i1", (Value)Float.make((float)2.0f));
        }
        catch (Exception exception4) {
            exception = exception4;
        }
        this.verify(exception != null);
        exception = null;
        try {
            this.a.set("bufB", (Value)new Buf(new byte[]{0, 0, 0}));
        }
        catch (Exception exception5) {
            exception = exception5;
        }
        this.verify(exception != null);
        exception = null;
        try {
            this.a.set("str", (Value)Str.make((String)"abcde"));
        }
        catch (Exception exception6) {
            exception = exception6;
        }
        this.verify(exception != null);
        exception = null;
        try {
            this.a.set("str", (Value)Str.make((String)"\u00ab"));
        }
        catch (Exception exception7) {
            exception = exception7;
        }
        this.verify(exception != null);
    }

    public void buildApp() throws Exception {
        this.schema = Schema.load((KitPart[])new KitPart[]{KitPart.forLocalKit((String)"sys")});
        this.app = new OfflineApp(this.schema);
        this.a = new OfflineComponent(this.schema.type("sys::TestComp"), "a");
        this.a.setInt("b1", 240);
        this.a.setInt("s1", 32000);
        this.a.setInt("i1", -19088888);
        this.a.setFloat("f1", 4.08f);
        this.b = new OfflineComponent(this.schema.type("sys::TestComp"), "b");
        this.c = new OfflineComponent(this.schema.type("sys::SubTestComp"), "c");
        this.c.setInt("sb", 7);
        this.c.setInt("si", 1972);
        this.app.add((OfflineComponent)this.app, this.a);
        this.app.add(this.a, this.b);
        this.app.add(this.a, this.c);
        this.app.assignIds();
        this.app.addLink(new OfflineLink(this.a, this.a.slot("b1"), this.b, this.b.slot("b2")));
    }
}

