/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.asm.CodeAsm;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrMethod;
import sedonac.ir.IrOp;

public class InlineConsts
extends CompilerStep {
    public InlineConsts(Compiler compiler) {
        super(compiler);
    }

    @Override
    public void run() {
        this.log.debug("  InlineConsts");
        this.predefines();
        for (int i = 0; i < this.flat.methods.length; ++i) {
            this.inline(this.flat.methods[i]);
        }
        this.quitIfErrors();
    }

    private void predefines() {
        this.predefine("sys::Sys.sizeofRef", this.compiler.image.refSize);
        this.predefine("sys::Sys.kitsLen", this.flat.kits.length);
        this.predefine("sys::Sys.logsLen", this.flat.logDefines.length);
    }

    private void predefine(String string, int n) {
        IrField irField = (IrField)this.ns.resolveSlot(string);
        irField.define = new Expr.Literal(new Location("synthetic"), this.ns, 3, (Object)new Integer(n));
    }

    private void inline(IrMethod irMethod) {
        if (irMethod.code == null) {
            return;
        }
        IrOp[] irOpArray = irMethod.code;
        for (int i = 0; i < irOpArray.length; ++i) {
            irOpArray[i] = this.inline(irOpArray[i]);
        }
    }

    private IrOp inline(IrOp irOp) {
        switch (irOp.opcode) {
            case 233: {
                return this.sizeOf(irOp);
            }
            case 28: {
                return this.loadDefine(irOp);
            }
        }
        return irOp;
    }

    private IrOp sizeOf(IrOp irOp) {
        int n = irOp.argToType().sizeof();
        return CodeAsm.loadIntOp(n);
    }

    private IrOp loadDefine(IrOp irOp) {
        IrField irField = irOp.argToField();
        if (irField.type.isLog()) {
            irOp.opcode = 210;
            return irOp;
        }
        if (irField.type.isArray()) {
            irOp.opcode = 238;
            irOp.resolvedArg = irField.define();
            return irOp;
        }
        return CodeAsm.loadLiteral(irField.define);
    }
}

