/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.Env;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.namespace.Type;

public class GenNativeTable
extends CompilerStep {
    NativeKit[] nativeKits;
    HashMap patches = new HashMap();

    public GenNativeTable(Compiler compiler) {
        super(compiler);
        for (int i = 0; i < compiler.platform.nativePatches.length; ++i) {
            this.patches.put(compiler.platform.nativePatches[i], "");
        }
    }

    @Override
    public void run() {
        File file = new File(this.compiler.outDir, "nativetable.c");
        this.log.info("  GenNativeTable [" + file + "]");
        try {
            Printer printer = new Printer(new PrintWriter(new FileWriter(file)));
            this.generate(printer);
            printer.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write stub file", new Location(file), (Throwable)exception);
        }
    }

    private void generate(Printer printer) {
        NativeKit nativeKit;
        int n;
        this.findNativeMethods();
        this.orderKits();
        this.orderMethods();
        printer.w("//").nl();
        printer.w("// Generated by sedonac ").w(Env.version).nl();
        printer.w("// ").w(Env.timestamp()).nl();
        printer.w("//").nl();
        printer.nl();
        printer.w("#include \"sedona.h\"").nl();
        printer.nl();
        for (n = 0; n < this.nativeKits.length; ++n) {
            int n2;
            nativeKit = this.nativeKits[n];
            if (nativeKit == null) continue;
            printer.w("////////////////////////////////////////////////////////////////").nl();
            printer.w("// ").w(nativeKit.kitName).w(" (kitId=").w(nativeKit.kitId).w(")").nl();
            printer.w("////////////////////////////////////////////////////////////////").nl();
            printer.nl();
            for (n2 = 0; n2 < nativeKit.methods.length; ++n2) {
                this.forward(printer, nativeKit.methods[n2]);
            }
            printer.w("// native table for kit ").w(n).nl();
            printer.w("NativeMethod ").w("kitNatives").w(n).w("[] = ").nl();
            printer.w("{").nl();
            for (n2 = 0; n2 < nativeKit.methods.length; ++n2) {
                IrMethod irMethod = nativeKit.methods[n2];
                printer.w("  ").w(TextUtil.pad((String)(this.toFuncName(irMethod) + ","), (int)30)).w("  // ").w(nativeKit.kitId).w("::").w(n2).nl();
            }
            printer.w("};").nl();
            printer.nl();
        }
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.w("// Native Table").nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.nl();
        printer.w("NativeMethod* ").w("nativeTable[] = ").nl();
        printer.w("{").nl();
        for (n = 0; n < this.nativeKits.length; ++n) {
            nativeKit = this.nativeKits[n];
            String string = nativeKit == null ? "NULL," : "kitNatives" + n + ",";
            printer.w("  ").w(TextUtil.pad((String)string, (int)15)).w("  // " + n).nl();
        }
        printer.w("};").nl();
        printer.nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.w("// Native Id Check").nl();
        printer.w("////////////////////////////////////////////////////////////////").nl();
        printer.nl();
        printer.w("#ifdef SCODE_DEBUG").nl();
        printer.w("int isNativeIdValid(int kitId, int methodId)").nl();
        printer.w("{").nl();
        printer.w("  switch(kitId)").nl();
        printer.w("  {").nl();
        for (n = 0; n < this.nativeKits.length; ++n) {
            IrMethod[] irMethodArray;
            nativeKit = this.nativeKits[n];
            if (nativeKit == null || (irMethodArray = nativeKit.methods).length == 0) continue;
            if (irMethodArray[irMethodArray.length - 1] == null) {
                throw new IllegalStateException();
            }
            printer.w("    case ").w(nativeKit.kitId).w(":").nl();
            printer.w("      if (methodId >= ").w(irMethodArray.length).w(") return 0;").nl();
            printer.w("      else return kitNatives").w(nativeKit.kitId).w("[methodId] != NULL;").nl();
        }
        printer.w("    default:").nl();
        printer.w("       return 0;").nl();
        printer.w("  }").nl();
        printer.w("}").nl();
        printer.w("#endif").nl();
        printer.nl().nl();
    }

    private void forward(Printer printer, IrMethod irMethod) {
        if (irMethod == null) {
            return;
        }
        printer.w("// ").w(irMethod.ret).w(" ").w(irMethod.parent.name).w(".").w(irMethod.name).w("(");
        for (int i = 0; i < irMethod.params.length; ++i) {
            Type type = irMethod.params[i];
            if (i > 0) {
                printer.w(", ");
            }
            printer.w(type);
        }
        printer.w(")").nl();
        printer.w("Cell ").w(this.toFuncName(irMethod)).w("(SedonaVM* vm, Cell* params);").nl().nl();
    }

    private String toFuncName(IrMethod irMethod) {
        if (irMethod == null) {
            return "NULL";
        }
        String string = irMethod.parent.kit.name + "_" + irMethod.parent.name + "_" + irMethod.name;
        if (this.patches.get(irMethod.qname()) != null) {
            string = string + "_patch";
        }
        return string;
    }

    private void findNativeMethods() {
        HashMap<Integer, NativeKit> hashMap = new HashMap<Integer, NativeKit>();
        IrKit[] irKitArray = this.compiler.kits;
        for (int i = 0; i < irKitArray.length; ++i) {
            IrType[] irTypeArray = irKitArray[i].types;
            for (int j = 0; j < irTypeArray.length; ++j) {
                IrSlot[] irSlotArray = irTypeArray[j].declared;
                for (int k = 0; k < irSlotArray.length; ++k) {
                    if (!irSlotArray[k].isMethod() || !irSlotArray[k].isNative()) continue;
                    IrMethod irMethod = (IrMethod)irSlotArray[k];
                    Integer n = new Integer(irMethod.nativeId.kitId);
                    NativeKit nativeKit = (NativeKit)hashMap.get(n);
                    if (nativeKit == null) {
                        nativeKit = new NativeKit(irMethod);
                        hashMap.put(n, nativeKit);
                    }
                    nativeKit.acc.add(irMethod);
                }
            }
        }
        this.nativeKits = hashMap.values().toArray(new NativeKit[hashMap.size()]);
    }

    private void orderKits() {
        int n = 0;
        for (int i = 0; i < this.nativeKits.length; ++i) {
            n = Math.max(n, this.nativeKits[i].kitId);
        }
        NativeKit[] nativeKitArray = new NativeKit[n + 1];
        for (int i = 0; i < this.nativeKits.length; ++i) {
            NativeKit nativeKit;
            nativeKitArray[nativeKit.kitId] = nativeKit = this.nativeKits[i];
        }
        this.nativeKits = nativeKitArray;
    }

    private void orderMethods() {
        for (int i = 0; i < this.nativeKits.length; ++i) {
            this.orderMethods(this.nativeKits[i]);
        }
    }

    private void orderMethods(NativeKit nativeKit) {
        if (nativeKit == null) {
            return;
        }
        nativeKit.methods = nativeKit.acc.toArray(new IrMethod[nativeKit.acc.size()]);
        nativeKit.acc = null;
        int n = nativeKit.methods[0].nativeId.kitId;
        int n2 = 0;
        for (int i = 0; i < nativeKit.methods.length; ++i) {
            IrMethod irMethod = nativeKit.methods[i];
            if (irMethod.nativeId.kitId != n) {
                this.err("Native kitIds must all be the same", irMethod.nativeId.loc);
            }
            n2 = Math.max(n2, irMethod.nativeId.methodId);
        }
        IrMethod[] irMethodArray = new IrMethod[n2 + 1];
        for (int i = 0; i < nativeKit.methods.length; ++i) {
            IrMethod irMethod;
            irMethodArray[irMethod.nativeId.methodId] = irMethod = nativeKit.methods[i];
        }
        nativeKit.methods = irMethodArray;
    }

    public static class Printer
    extends PrintWriter {
        public int indent;

        public Printer(PrintWriter printWriter) {
            super(printWriter);
        }

        public Printer w(Object object) {
            this.print(object);
            return this;
        }

        public Printer w(int n) {
            this.print(n);
            return this;
        }

        public Printer indent() {
            this.print(TextUtil.getSpaces((int)(this.indent * 2)));
            return this;
        }

        public Printer nl() {
            this.println();
            return this;
        }
    }

    static class NativeKit {
        String kitName;
        int kitId;
        ArrayList acc = new ArrayList();
        IrMethod[] methods;

        NativeKit(IrMethod irMethod) {
            this.kitName = irMethod.parent.kit.name;
            this.kitId = irMethod.nativeId.kitId;
        }
    }
}

